/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.util;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Oid;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.Set;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CRLException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class DegeneratePKCS7 {
    private Asn1 asn1 = null;
    private Vector certs;
    private Vector crls;

    public DegeneratePKCS7(InputStream inputStream) throws IOException, Asn1Exception, CertificateException, CRLException {
        this(inputStream, null);
    }

    public DegeneratePKCS7(InputStream inputStream, String string) throws IOException, Asn1Exception, CertificateException, CRLException {
        X509Extension x509Extension;
        Asn1 asn1;
        Iterator iterator;
        CertificateFactory certificateFactory;
        try {
            certificateFactory = string == null ? CertificateFactory.getInstance("X.509", "DSTC_X509") : CertificateFactory.getInstance("X.509", string);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.asn1 = Asn1.getAsn1(inputStream);
        Iterator iterator2 = this.asn1.components();
        iterator2.next();
        Asn1 asn12 = (Asn1)((Asn1)iterator2.next()).components().next();
        Iterator iterator3 = asn12.components();
        iterator3.next();
        iterator3.next();
        iterator3.next();
        Asn1 asn13 = (Asn1)iterator3.next();
        ByteArrayInputStream byteArrayInputStream = null;
        if (asn13.getTagNumber() == 0) {
            this.certs = new Vector();
            iterator = asn13.components();
            while (iterator.hasNext()) {
                asn1 = (Asn1)iterator.next();
                if (asn1 == null) break;
                byteArrayInputStream = new ByteArrayInputStream(asn1.getEncoded());
                x509Extension = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                this.certs.add(x509Extension);
            }
            asn13 = (Asn1)iterator3.next();
        }
        if (asn13.getTagNumber() == 1) {
            this.crls = new Vector();
            iterator = asn13.components();
            while (iterator.hasNext()) {
                asn1 = (Asn1)iterator.next();
                if (asn1 == null) break;
                byteArrayInputStream = new ByteArrayInputStream(asn1.getEncoded());
                x509Extension = (X509CRL)certificateFactory.generateCRL(byteArrayInputStream);
                this.crls.add(x509Extension);
            }
            asn13 = (Asn1)iterator3.next();
        }
    }

    public DegeneratePKCS7(Vector vector, Vector vector2) throws Asn1Exception, CertificateException, CRLException {
        this.certs = vector;
        this.crls = vector2;
        this.encode();
    }

    private void encode() throws Asn1Exception, CertificateException, CRLException {
        Iterator iterator;
        Asn1 asn1;
        Sequence sequence = new Sequence();
        sequence.add(new Integer(1));
        sequence.add(new Set());
        Sequence sequence2 = new Sequence();
        sequence2.add(new Oid("1.2.840.113549.1.7.1"));
        sequence.add(sequence2);
        if (this.certs != null) {
            asn1 = new Set();
            iterator = ((AbstractList)this.certs).iterator();
            while (iterator.hasNext()) {
                asn1.add(Asn1.getAsn1(((X509Certificate)iterator.next()).getEncoded()));
            }
            asn1.setTagClass(128);
            asn1.setTagNumber(0);
            sequence.add(asn1);
        }
        if (this.crls != null) {
            asn1 = new Set();
            iterator = ((AbstractList)this.crls).iterator();
            while (iterator.hasNext()) {
                asn1.add(Asn1.getAsn1(((X509CRL)iterator.next()).getEncoded()));
            }
            asn1.setTagClass(128);
            asn1.setTagNumber(1);
            sequence.add(asn1);
        }
        sequence.add(new Set());
        this.asn1 = new Sequence();
        this.asn1.add(new Oid("1.2.840.113549.1.7.2"));
        asn1 = new Explicit(128, 0);
        asn1.add(sequence);
        this.asn1.add(asn1);
    }

    public Vector getCRLs() {
        return this.crls;
    }

    public Vector getCertificates() {
        return this.certs;
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }
}

