/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.x509.Extension;
import java.io.IOException;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;

public class Extensions {
    private Asn1 asn1 = null;
    private Vector extns = null;

    public Extensions() {
    }

    public Extensions(Asn1 asn1) throws Asn1Exception {
        if (asn1 == null) {
            throw new Asn1Exception("null asn1");
        }
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        this.extns = new Vector();
        while (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 == null) break;
            this.extns.add(new Extension(asn12));
        }
    }

    public Extensions(InputStream inputStream) throws IOException, Asn1Exception {
        this(Asn1.getAsn1(inputStream));
    }

    public Extensions(Vector vector) {
        this.asn1 = new Sequence();
        this.extns = vector;
        Iterator iterator = ((AbstractList)vector).iterator();
        while (iterator.hasNext()) {
            this.asn1.add(((Extension)iterator.next()).getAsn1());
        }
    }

    public void addExtension(Extension extension) {
        if (this.extns == null) {
            this.extns = new Vector();
        }
        this.extns.add(extension);
    }

    public Asn1 getAsn1() {
        return this.asn1;
    }

    public Set getCriticalOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (!extension.isCritical()) continue;
            hashSet.add(extension.getExtnID());
        }
        return hashSet;
    }

    public Vector getExtensions() {
        return this.extns;
    }

    public Set getNonCriticalOIDs() {
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            Extension extension = (Extension)iterator.next();
            if (extension.isCritical()) continue;
            hashSet.add(extension.getExtnID());
        }
        return hashSet;
    }

    public byte[] getValue(String string) {
        try {
            Iterator iterator = ((AbstractList)this.extns).iterator();
            while (iterator.hasNext()) {
                Extension extension = (Extension)iterator.next();
                if (!extension.getExtnID().equals(string)) continue;
                return extension.getExtnValue().getEncoded();
            }
            return null;
        }
        catch (Asn1Exception asn1Exception) {
            throw new RuntimeException("bad encoding");
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = ((AbstractList)this.extns).iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(((Extension)iterator.next()).toString());
        }
        return stringBuffer.toString();
    }
}

