/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.x509.TBSCertificate;
import com.dstc.security.x509.extns.BasicConstraints;
import com.dstc.security.x509.extns.KeyUsage;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class X509Certificate
extends java.security.cert.X509Certificate {
    protected Asn1 asn1 = null;
    protected TBSCertificate tbs;
    protected AlgorithmId sigAlg;
    protected byte[] sigData;

    public X509Certificate() {
    }

    public X509Certificate(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        if (!(asn1 instanceof Sequence)) {
            throw new Asn1Exception("Bad certificate encoding");
        }
        Iterator iterator = asn1.components();
        this.tbs = new TBSCertificate((Asn1)iterator.next());
        this.sigAlg = new AlgorithmId((Asn1)iterator.next());
        this.sigData = ((BitString)iterator.next()).getBytes();
    }

    public X509Certificate(InputStream inputStream) throws Asn1Exception, IOException {
        this(Asn1.getAsn1(inputStream));
    }

    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        Date date = new Date();
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("Certficate Expired on: " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("Certficate Not Valid until " + this.getNotBefore());
        }
    }

    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.after(this.getNotAfter())) {
            throw new CertificateExpiredException("Certficate Expires on: " + this.getNotAfter());
        }
        if (date.before(this.getNotBefore())) {
            throw new CertificateNotYetValidException("Certficate Not Valid until " + this.getNotBefore());
        }
    }

    public boolean equals(Object object) {
        try {
            if (object instanceof java.security.cert.X509Certificate) {
                return Arrays.equals(this.getEncoded(), ((java.security.cert.X509Certificate)object).getEncoded());
            }
            return false;
        }
        catch (CertificateEncodingException certificateEncodingException) {
            return false;
        }
    }

    public int getBasicConstraints() {
        byte[] byArray = this.getExtensionValue("2.5.29.19");
        if (byArray == null) {
            return -1;
        }
        try {
            BasicConstraints basicConstraints = new BasicConstraints(Asn1.getAsn1(byArray));
            return basicConstraints.getBasicConstraints();
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.toString());
        }
    }

    public Set getCriticalExtensionOIDs() {
        if (this.tbs.getExtensions() == null) {
            return new HashSet();
        }
        return this.tbs.getExtensions().getCriticalOIDs();
    }

    public byte[] getEncoded() throws CertificateEncodingException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CertificateEncodingException(asn1Exception.toString());
        }
    }

    public byte[] getExtensionValue(String string) {
        if (this.tbs.getExtensions() == null) {
            return null;
        }
        return this.tbs.getExtensions().getValue(string);
    }

    public Principal getIssuerDN() {
        return this.tbs.getIssuer();
    }

    public boolean[] getIssuerUniqueID() {
        byte[] byArray = this.tbs.getIssuerUniqueId();
        if (byArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[8 * byArray.length];
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 < 8) {
                blArray[n * 8 + n2] = (byArray[n] >>> n2 & 1) != 0;
                ++n2;
            }
            ++n;
        }
        return blArray;
    }

    public boolean[] getKeyUsage() {
        byte[] byArray = this.getExtensionValue("2.5.29.15");
        if (byArray == null) {
            return null;
        }
        try {
            KeyUsage keyUsage = new KeyUsage(Asn1.getAsn1(byArray));
            return keyUsage.getKeyUsage();
        }
        catch (Exception exception) {
            throw new RuntimeException("Internal error: " + exception.toString());
        }
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.tbs.getExtensions() == null) {
            return new HashSet();
        }
        return this.tbs.getExtensions().getNonCriticalOIDs();
    }

    public Date getNotAfter() {
        if (this.tbs.getValidity() == null) {
            return null;
        }
        return this.tbs.getValidity().getNotAfter();
    }

    public Date getNotBefore() {
        if (this.tbs.getValidity() == null) {
            return null;
        }
        return this.tbs.getValidity().getNotBefore();
    }

    public PublicKey getPublicKey() {
        try {
            String string = OID.getAlgName(this.tbs.getSubjectPubKeyInfo().getAlgorithmId().getOid());
            KeyFactory keyFactory = KeyFactory.getInstance(string);
            return keyFactory.generatePublic(new X509EncodedKeySpec(this.tbs.getSubjectPubKeyInfo().getAsn1().getEncoded()));
        }
        catch (Exception exception) {
            throw new RuntimeException("bad public key");
        }
    }

    public BigInteger getSerialNumber() {
        return this.tbs.getSerialNumber();
    }

    public String getSigAlgName() {
        return OID.getAlgName(this.sigAlg.getOid());
    }

    public String getSigAlgOID() {
        return this.sigAlg.getOid();
    }

    public byte[] getSigAlgParams() {
        try {
            return this.sigAlg.getParams().getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public byte[] getSignature() {
        return this.sigData;
    }

    public Principal getSubjectDN() {
        return this.tbs.getSubject();
    }

    public boolean[] getSubjectUniqueID() {
        byte[] byArray = this.tbs.getSubjectUniqueId();
        if (byArray == null) {
            return null;
        }
        boolean[] blArray = new boolean[8 * byArray.length];
        int n = 0;
        while (n < byArray.length) {
            int n2 = 0;
            while (n2 < 8) {
                blArray[n * 8 + n2] = (byArray[n] >>> n2 & 1) != 0;
                ++n2;
            }
            ++n;
        }
        return blArray;
    }

    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.tbs.getAsn1().getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new CertificateEncodingException(asn1Exception.toString());
        }
    }

    public int getVersion() {
        return this.tbs.getVersion() + 1;
    }

    public boolean hasUnsupportedCriticalExtension() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("X509 Certificate, version " + this.getVersion() + "\n");
        stringBuffer.append("Serial Number: " + this.getSerialNumber().toString() + "\n");
        stringBuffer.append("Issuer: " + this.getIssuerDN().getName() + "\n");
        stringBuffer.append("Subject: " + this.getSubjectDN().getName() + "\n");
        stringBuffer.append("Key Algorithm: " + this.getPublicKey().getAlgorithm() + "\n");
        stringBuffer.append(String.valueOf(this.getPublicKey().toString()) + "\n");
        stringBuffer.append("Signature Algorithm: " + this.getSigAlgName());
        stringBuffer.append(" (" + this.getSigAlgOID() + ")\n");
        stringBuffer.append("Valid Not Before: " + this.getNotBefore() + "\n");
        stringBuffer.append("Valid Not After: " + this.getNotAfter() + "\n");
        if (this.tbs.getExtensions() != null) {
            stringBuffer.append(this.tbs.getExtensions().toString());
        }
        return stringBuffer.toString();
    }

    public void verify(PublicKey publicKey) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        this.verify(publicKey, "DSTC");
    }

    public void verify(PublicKey publicKey, String string) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        try {
            Signature signature = Signature.getInstance(this.getSigAlgName(), string);
            signature.initVerify(publicKey);
            signature.update(this.getTBSCertificate());
            boolean bl = signature.verify(this.getSignature());
            if (!bl) {
                throw new CertificateException("Bad signature");
            }
        }
        catch (Exception exception) {
            throw new CertificateException(exception.toString());
        }
    }
}

