/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Integer;
import com.dstc.security.x509.ExtensionValue;
import java.math.BigInteger;

public class CRLNumber
implements ExtensionValue {
    private BigInteger num;
    private Asn1 asn1;

    public CRLNumber(Asn1 asn1) {
        this.asn1 = asn1;
        this.num = ((Integer)asn1).getBigInteger();
    }

    public CRLNumber(BigInteger bigInteger) {
        this.num = bigInteger;
        this.asn1 = new Integer(bigInteger);
    }

    public BigInteger getBigInteger() {
        return this.num;
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CRLNumber extension:\n");
        stringBuffer.append("  " + this.num.toString() + "\n");
        return stringBuffer.toString();
    }
}

