/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.x509.ExtensionValue;
import java.io.IOException;

public class NetscapeCertType
implements ExtensionValue {
    public static final byte SSL_CLIENT = -128;
    public static final byte SSL_SERVER = 64;
    public static final byte SMIME = 32;
    public static final byte OBJECT_SIGNING = 16;
    public static final byte SSL_CA = 4;
    public static final byte SMIME_CA = 2;
    public static final byte OBJECT_SIGNING_CA = 1;
    private byte type;
    private Asn1 asn1;

    public NetscapeCertType(byte by) {
        this.type = by;
        byte[] byArray = new byte[]{by};
        this.asn1 = new BitString(byArray);
    }

    public NetscapeCertType(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        this.type = ((BitString)asn1).getBytes()[0];
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NetscapeCertType extension:\n");
        if ((this.type & 4) != 0) {
            stringBuffer.append("  SSL CA\n");
        }
        if ((this.type & 0xFFFFFF80) != 0) {
            stringBuffer.append("  SSL CLIENT\n");
        }
        if ((this.type & 0x10) != 0) {
            stringBuffer.append("  OBJECT SIGNING\n");
        }
        if ((this.type & 0x40) != 0) {
            stringBuffer.append("  SSL SERVER\n");
        }
        if ((this.type & 0x20) != 0) {
            stringBuffer.append("  SMIME\n");
        }
        if ((this.type & 2) != 0) {
            stringBuffer.append("  SMIME CA\n");
        }
        if ((this.type & 1) != 0) {
            stringBuffer.append("  OBJECT SIGNING CA\n");
        }
        return stringBuffer.toString();
    }
}

