/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.x509.ExtensionValue;
import com.dstc.security.x509.GeneralName;
import com.dstc.security.x509.GeneralNames;
import java.io.IOException;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class SubjectAltName
implements ExtensionValue {
    private Asn1 asn1;
    private Vector altNames;

    public SubjectAltName() {
    }

    public SubjectAltName(Asn1 asn1) throws Asn1Exception, IOException {
        this.asn1 = asn1;
        this.altNames = new GeneralNames(asn1).getNames();
    }

    public SubjectAltName(String string) {
        if (this.altNames == null) {
            this.altNames = new Vector();
        }
        this.altNames.add(new GeneralName(1, string));
        this.asn1 = new GeneralNames(this.altNames).getAsn1();
    }

    public void addAltName(GeneralName generalName) {
        if (this.altNames == null) {
            this.altNames = new Vector();
        }
        this.altNames.add(generalName);
        if (this.asn1 == null) {
            Vector<GeneralName> vector = new Vector<GeneralName>();
            vector.add(generalName);
            this.asn1 = new GeneralNames(vector).getAsn1();
        } else {
            this.asn1 = new GeneralNames(this.altNames).getAsn1();
        }
    }

    public byte[] getEncoded() throws Asn1Exception {
        return this.asn1.getEncoded();
    }

    public Vector getNames() {
        if (this.altNames != null) {
            return this.altNames;
        }
        return null;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("SubjectAltName extension:\n");
        if (this.altNames != null) {
            Iterator iterator = ((AbstractList)this.altNames).iterator();
            while (iterator.hasNext()) {
                stringBuffer.append("  " + ((GeneralName)iterator.next()).getName() + "\n");
            }
        }
        return stringBuffer.toString();
    }
}

