/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509.extns;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.BMPString;
import com.dstc.security.asn1.IA5String;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTF8String;
import com.dstc.security.asn1.VisibleString;
import com.dstc.security.x509.extns.DisplayText;
import com.dstc.security.x509.extns.NoticeReference;
import com.dstc.security.x509.extns.Qualifier;
import java.io.IOException;
import java.util.Iterator;

public class UserNotice
extends Qualifier {
    private NoticeReference ref;
    private DisplayText text;

    public UserNotice(Asn1 asn1) throws IOException {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        if (iterator.hasNext()) {
            Asn1 asn12 = (Asn1)iterator.next();
            if (asn12 instanceof Sequence) {
                this.ref = new NoticeReference(asn12);
            }
            if (iterator.hasNext()) {
                asn12 = (Asn1)iterator.next();
                if (asn12 instanceof VisibleString || asn12 instanceof BMPString || asn12 instanceof UTF8String || asn12 instanceof IA5String) {
                    this.text = new DisplayText(asn12);
                } else {
                    throw new IOException("Expecting DisplayText");
                }
            }
        }
    }

    public UserNotice(NoticeReference noticeReference, DisplayText displayText) throws IOException {
        this.asn1 = new Sequence();
        this.ref = noticeReference;
        ((Sequence)this.asn1).add(noticeReference.getAsn1());
        this.text = displayText;
        ((Sequence)this.asn1).add(displayText.getAsn1());
    }

    public String getExplicitText() {
        if (this.text == null) {
            return null;
        }
        return this.text.getText();
    }

    public NoticeReference getNoticeReference() {
        return this.ref;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.ref != null) {
            stringBuffer.append(this.ref.toString());
        }
        if (this.text != null) {
            stringBuffer.append("   Explicit Text: " + this.text.toString() + "\n");
        }
        return stringBuffer.toString();
    }
}

