/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.Integer;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.APOptions;
import com.dstc.security.kerberos.Authenticator;
import com.dstc.security.kerberos.AuthorizationDataElement;
import com.dstc.security.kerberos.Checksum;
import com.dstc.security.kerberos.DecryptionException;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.NotYetDecryptedException;
import com.dstc.security.kerberos.PrincipalName;
import com.dstc.security.kerberos.Ticket;
import com.dstc.security.kerberos.TicketImpl;
import com.dstc.security.kerberos.creds.Credential;
import com.dstc.security.kerberos.msg.APReq;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;

final class APReqImpl
implements APReq {
    private Asn1 asn1 = null;
    private int pvno = 5;
    private int msgType = 14;
    private APOptions apOptions;
    private EncryptedDataImpl encAuthenticator;
    private EncryptionKey subKey = null;
    private String realm = null;
    private Checksum checksum = null;
    private int seqNum = -1;
    private Date ctime = null;
    private int cusec = 0;
    private KerberosCipher cipher = null;
    private Authenticator auth = null;
    private TicketImpl ticket = null;
    private PrincipalName clientName = null;
    private Vector authData = null;
    private boolean decryptedOK = false;

    APReqImpl(Asn1 asn1) throws Asn1Exception, KerberosException {
        this.asn1 = asn1;
        if (this.asn1.getTagNumber() != 14) {
            throw new KerberosException("Wrong tag for an APReq");
        }
        Iterator iterator = ((Sequence)asn1.components().next()).components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.pvno) {
            throw new KerberosException("Not version 5");
        }
        asn12 = (Asn1)iterator.next();
        if (((Integer)asn12.components().next()).getInt() != this.msgType) {
            throw new KerberosException("Wrong msgType for an APReq");
        }
        asn12 = (Asn1)iterator.next();
        this.apOptions = new APOptions((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        this.ticket = new TicketImpl((Asn1)asn12.components().next());
        asn12 = (Asn1)iterator.next();
        this.encAuthenticator = new EncryptedDataImpl((Asn1)asn12.components().next());
    }

    APReqImpl(Credential credential, APOptions aPOptions, SecureRandom secureRandom) throws KerberosException {
        this.apOptions = aPOptions;
        this.cipher = KerberosCipher.getInstance(credential.getSessionKey().keyType(), null);
        this.cipher.initEncrypt(credential.getSessionKey(), secureRandom);
        this.setTicket(credential.getTicket());
        this.setClientName(credential.getClientName());
        this.setRealm(credential.getClientRealm());
    }

    APReqImpl(byte[] byArray) throws Asn1Exception, KerberosException {
        this(Asn1.getAsn1(byArray));
    }

    void addAuthData(AuthorizationDataElement authorizationDataElement) {
        if (this.authData == null) {
            this.authData = new Vector();
        }
        this.authData.add(authorizationDataElement);
    }

    public void decrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new DecryptionException("Cipher not yet set");
        }
        try {
            this.auth = new Authenticator(Asn1.getAsn1(this.cipher.decrypt(this.encAuthenticator)));
            this.decryptedOK = true;
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.realm = this.auth.getRealm();
        this.clientName = this.auth.getClientName();
        this.checksum = this.auth.getChecksum();
        this.ctime = this.auth.getCTime();
        this.cusec = this.auth.getCusec();
        this.subKey = this.auth.getSubKey();
        this.seqNum = this.auth.getSeqNumber();
        this.authData = this.auth.getAuthData();
    }

    private void encode() {
        this.asn1 = new Explicit(64, this.msgType);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new Integer(this.pvno));
        sequence.add(explicit);
        explicit = new Explicit(128, 1);
        explicit.add(new Integer(this.msgType));
        sequence.add(explicit);
        explicit = new Explicit(128, 2);
        explicit.add(this.apOptions.getAsn1());
        sequence.add(explicit);
        explicit = new Explicit(128, 3);
        explicit.add(this.ticket.getAsn1());
        sequence.add(explicit);
        explicit = new Explicit(128, 4);
        explicit.add(this.encAuthenticator.getAsn1());
        sequence.add(explicit);
        this.asn1.add(sequence);
    }

    void encrypt() throws KerberosException {
        if (this.cipher == null) {
            throw new KerberosException("Cipher not yet set");
        }
        if (this.ctime == null) {
            throw new KerberosException("Client time not yet set");
        }
        this.auth = new Authenticator(this.realm, this.clientName, this.checksum, this.ctime, this.subKey, this.seqNum, this.authData);
        try {
            this.encAuthenticator = new EncryptedDataImpl(this.cipher.encrypt(this.auth.getAsn1().getEncoded()));
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
        this.encode();
    }

    public int encryptionType() {
        return this.encAuthenticator.getEncryptionType();
    }

    public APOptions getAPOptions() {
        return this.apOptions;
    }

    public AuthorizationDataElement[] getAuthorizationData() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        if (this.authData == null) {
            return null;
        }
        AuthorizationDataElement[] authorizationDataElementArray = new AuthorizationDataElement[this.authData.size()];
        this.authData.toArray(authorizationDataElementArray);
        return authorizationDataElementArray;
    }

    public Checksum getChecksum() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.auth.getChecksum();
    }

    public PrincipalName getClientName() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.clientName;
    }

    public String getClientRealm() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.realm;
    }

    public Date getClientTime() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.ctime;
    }

    public int getCusec() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.cusec;
    }

    public byte[] getEncoded() throws KerberosException {
        try {
            return this.asn1.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int getSequenceNumber() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.seqNum;
    }

    public EncryptionKey getSubKey() throws NotYetDecryptedException {
        if (this.auth == null) {
            throw new NotYetDecryptedException("APReq not yet decrypted");
        }
        return this.subKey;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void initDecrypt(EncryptionKey encryptionKey) throws KerberosException {
        if (encryptionKey == null) {
            throw new KerberosException("Cannot decrypt with null key");
        }
        int n = this.encAuthenticator.getEncryptionType();
        if (!KerberosCipher.checkEncType(n, encryptionKey.keyType())) {
            throw new KerberosException("key type mismatch");
        }
        this.cipher = KerberosCipher.getInstance(n, null);
        this.cipher.initDecrypt(encryptionKey, null);
    }

    void setChecksum(Checksum checksum) {
        this.checksum = checksum;
    }

    private void setClientName(PrincipalName principalName) {
        this.clientName = new PrincipalName(principalName.nameType(), principalName.nameComponents());
    }

    void setClientTime(Date date) {
        this.ctime = date;
    }

    private void setRealm(String string) {
        this.realm = string;
    }

    void setSequenceNumber(int n) {
        this.seqNum = n;
    }

    void setSubKey(EncryptionKey encryptionKey) {
        this.subKey = encryptionKey;
    }

    private void setTicket(Ticket ticket) throws KerberosException {
        try {
            this.ticket = new TicketImpl(ticket.getEncoded());
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n++++ KRB-AP-REQ Message ++++");
        stringBuffer.append("\nencryption type: " + this.encryptionType());
        if (this.auth != null && this.decryptedOK) {
            stringBuffer.append(" (DECRYPTED OK)");
        }
        stringBuffer.append("\nap options: " + this.getAPOptions());
        stringBuffer.append(this.getTicket());
        try {
            stringBuffer.append("\nclient: " + this.getClientName() + "@" + this.getClientRealm());
            stringBuffer.append("\nsubkey: " + this.getSubKey());
            stringBuffer.append("\nclient time: " + this.getClientTime());
            stringBuffer.append("\ncusec: " + this.getCusec());
            if (this.getSequenceNumber() != -1) {
                stringBuffer.append("\nsequence number: " + this.getSequenceNumber());
            }
        }
        catch (NotYetDecryptedException notYetDecryptedException) {}
        stringBuffer.append("\n++++++++++++++++++++++++++++");
        return stringBuffer.toString();
    }
}

