/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.OctetString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptionKey;
import java.util.Iterator;

final class EncryptionKeyImpl
implements EncryptionKey {
    private Asn1 asn1 = null;
    private int keyType;
    private byte[] keyValue;

    EncryptionKeyImpl(int n, byte[] byArray) {
        this.asn1 = new Sequence();
        this.keyType = n;
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new com.dstc.security.asn1.Integer(n));
        this.asn1.add(explicit);
        this.keyValue = byArray;
        explicit = new Explicit(128, 1);
        explicit.add(new OctetString(byArray));
        this.asn1.add(explicit);
    }

    EncryptionKeyImpl(Asn1 asn1) throws Asn1Exception {
        this.asn1 = asn1;
        Iterator iterator = asn1.components();
        Asn1 asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 0) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.keyType = ((com.dstc.security.asn1.Integer)asn12.components().next()).getInt();
        asn12 = (Asn1)iterator.next();
        if (asn12.getTagNumber() != 1) {
            throw new Asn1Exception("Bad Tag number");
        }
        this.keyValue = ((OctetString)asn12.components().next()).getBytes();
    }

    Asn1 getAsn1() {
        return this.asn1;
    }

    public int keyType() {
        return this.keyType;
    }

    public byte[] keyValue() {
        return (byte[])this.keyValue.clone();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[");
        stringBuffer.append(this.keyType).append(",  ");
        int n = 0;
        while (n < this.keyValue.length) {
            stringBuffer.append(String.valueOf(Integer.toHexString(this.keyValue[n] & 0xFF)) + " ");
            ++n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

