/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos;

import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.Explicit;
import com.dstc.security.asn1.GeneralizedTime;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.kerberos.EncryptedData;
import com.dstc.security.kerberos.EncryptedDataImpl;
import com.dstc.security.kerberos.EncryptionKey;
import com.dstc.security.kerberos.KerberosCipher;
import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.PaData;
import java.security.SecureRandom;
import java.util.Date;

public final class PaEncTimestamp
implements PaData {
    private int type = 2;
    private byte[] value;

    public PaEncTimestamp(EncryptionKey encryptionKey, SecureRandom secureRandom) throws KerberosException {
        KerberosCipher kerberosCipher = KerberosCipher.getInstance(encryptionKey.keyType(), null);
        kerberosCipher.initEncrypt(encryptionKey, secureRandom);
        Sequence sequence = new Sequence();
        Explicit explicit = new Explicit(128, 0);
        explicit.add(new GeneralizedTime(new Date()));
        sequence.add(explicit);
        try {
            EncryptedDataImpl encryptedDataImpl = new EncryptedDataImpl(kerberosCipher.encrypt(sequence.getEncoded()));
            this.value = ((EncryptedData)encryptedDataImpl).getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new KerberosException(asn1Exception.getMessage());
        }
    }

    public int type() {
        return this.type;
    }

    public byte[] value() {
        return this.value;
    }
}

