/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.crypto;

import com.dstc.security.kerberos.KerberosException;
import com.dstc.security.kerberos.crypto.CRC32Mac;
import com.dstc.security.kerberos.crypto.DESMac;
import com.dstc.security.kerberos.crypto.MD4Mac;
import com.dstc.security.kerberos.crypto.MD5Mac;

public abstract class KerberosMac {
    public abstract byte[] doFinal();

    public abstract void doFinal(byte[] var1, int var2, int var3);

    public static KerberosMac getInstance(int n) throws KerberosException {
        switch (n) {
            case 1: {
                return new CRC32Mac();
            }
            case 2: {
                return new MD4Mac();
            }
            case 4: {
                return new DESMac();
            }
            case 7: {
                return new MD5Mac();
            }
        }
        throw new KerberosException("Unsupported checksum type: " + n);
    }

    public void update(byte by) {
        byte[] byArray = new byte[]{by};
        this.update(byArray);
    }

    public abstract void update(byte[] var1);
}

