/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import org.ietf.jgss.GSSException;

final class GSSKrbException
extends GSSException {
    static final int KRB5_S_G_BAD_SERVICE_NAME = 1;
    static final int KRB5_S_G_BAD_STRING_UID = 2;
    static final int KRB5_S_G_NOUSER = 3;
    static final int KRB5_S_G_VALIDATE_FAILED = 4;
    static final int KRB5_S_G_BUFFER_ALLOC = 5;
    static final int KRB5_S_G_BAD_MSG_CTX = 6;
    static final int KRB5_S_G_WRONG_SIZE = 7;
    static final int KRB5_S_G_BAD_USAGE = 8;
    static final int KRB5_S_G_UNKNOWN_QOP = 9;
    static final int KRB5_S_KG_CCACHE_NOMATCH = 10;
    static final int KRB5_S_KG_KEYTAB_NOMATCH = 11;
    static final int KRB5_S_KG_TGT_MISSING = 12;
    static final int KRB5_S_KG_NO_SUBKEY = 13;
    static final int KRB5_S_KG_CONTEXT_ESTABLISHED = 14;
    static final int KRB5_S_KG_BAD_SIGN_TYPE = 15;
    static final int KRB5_S_KG_BAD_LENGTH = 16;
    static final int KRB5_S_KG_CTX_INCOMPLETE = 17;
    private static final String[] ERROR_MSGS = new String[]{"No error", "No @ in SERVICE-NAME name string", "STRING-UID-NAME contains nondigits", "UID does not resolve to username", "Validation error", "Couldn't allocate gss_buffer_t data", "Message context invalid", "Buffer is the wrong size", "Credential usage type is unknown", "Unknown quality of protection specified", "Principal in credential cache does not match desired name", "No principal in keytab matches desired name", "Credential cache has no TGT", "Authenticator has no subkey", "Context is already fully established", "Unknown signature type in token", "Invalid field length in token", "Attempt to use incomplete security context"};
    private static final int MIN_ERR_CODE = 1;
    private static final int MAX_ERR_CODE = ERROR_MSGS.length - 1;

    GSSKrbException(int n, int n2) {
        super(n, n2, GSSKrbException.getMinorString(n2));
    }

    private static String getMinorString(int n) {
        if (n < 1 || n > MAX_ERR_CODE) {
            return "Unknown minor code: " + n;
        }
        return ERROR_MSGS[n];
    }
}

