/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.kerberos.gssapi;

import com.dstc.security.kerberos.Kerberos;
import com.dstc.security.kerberos.gssapi.GSSContext;
import com.dstc.security.kerberos.gssapi.GSSCredential;
import com.dstc.security.kerberos.gssapi.GSSName;
import com.dstc.security.util.Dependencies;
import java.security.Provider;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

public final class GSSManager
extends org.ietf.jgss.GSSManager {
    public static final Oid KRB5 = GSSManager.createOid("1.2.840.113554.1.2.2");
    public static final Oid KRB5_NT_PRINCIPAL_NAME = GSSName.KRB5_NT_PRINCIPAL_NAME;
    public static final int KRB5_INTEG_QOP_MD5 = 1;
    public static final int KRB5_INTEG_QOP_DES_MD5 = 2;
    public static final int KRB5_INTEG_QOP_DES_MAC = 3;
    public static final int KRB5_CONF_QOP_DES = 0;
    static final Oid[] MECHS = new Oid[]{KRB5};
    static final Oid[] TYPES = new Oid[]{org.ietf.jgss.GSSName.NT_HOSTBASED_SERVICE, org.ietf.jgss.GSSName.NT_USER_NAME, org.ietf.jgss.GSSName.NT_EXPORT_NAME, KRB5_NT_PRINCIPAL_NAME};
    private Kerberos kerberos;
    static /* synthetic */ Class class$com$dstc$security$kerberos$gssapi$GSSManager;

    static {
        Dependencies.check(class$com$dstc$security$kerberos$gssapi$GSSManager != null ? class$com$dstc$security$kerberos$gssapi$GSSManager : (class$com$dstc$security$kerberos$gssapi$GSSManager = GSSManager.class$("com.dstc.security.kerberos.gssapi.GSSManager")), true);
    }

    public GSSManager() {
        this.kerberos = Kerberos.getInstance();
    }

    public GSSManager(Kerberos kerberos) {
        this.kerberos = kerberos;
    }

    public void addProviderAtEnd(Provider provider, Oid oid) throws GSSException {
        throw new GSSException(16);
    }

    public void addProviderAtFront(Provider provider, Oid oid) throws GSSException {
        throw new GSSException(16);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public org.ietf.jgss.GSSContext createContext(org.ietf.jgss.GSSCredential gSSCredential) throws GSSException {
        return new GSSContext(gSSCredential, this.kerberos);
    }

    public org.ietf.jgss.GSSContext createContext(org.ietf.jgss.GSSName gSSName, Oid oid, org.ietf.jgss.GSSCredential gSSCredential, int n) throws GSSException {
        return new GSSContext(gSSName, oid, gSSCredential, n, this.kerberos);
    }

    public org.ietf.jgss.GSSContext createContext(byte[] byArray) throws GSSException {
        return new GSSContext(byArray, this.kerberos);
    }

    public org.ietf.jgss.GSSCredential createCredential(int n) throws GSSException {
        return this.createCredential((org.ietf.jgss.GSSName)null, Integer.MAX_VALUE, (Oid)null, n);
    }

    public org.ietf.jgss.GSSCredential createCredential(org.ietf.jgss.GSSName gSSName, int n, Oid oid, int n2) throws GSSException {
        return new GSSCredential(gSSName, n, oid, n2, this.kerberos);
    }

    public org.ietf.jgss.GSSCredential createCredential(org.ietf.jgss.GSSName gSSName, int n, Oid[] oidArray, int n2) throws GSSException {
        if (oidArray == null) {
            oidArray = MECHS;
        }
        org.ietf.jgss.GSSCredential gSSCredential = this.createCredential(gSSName, n, oidArray[0], n2);
        int n3 = 1;
        int n4 = oidArray.length;
        while (n3 < n4) {
            gSSCredential.add(gSSName, n, n, oidArray[n3], n2);
            ++n3;
        }
        return gSSCredential;
    }

    public org.ietf.jgss.GSSName createName(String string, Oid oid) throws GSSException {
        return new GSSName(string, oid, this.kerberos);
    }

    public org.ietf.jgss.GSSName createName(String string, Oid oid, Oid oid2) throws GSSException {
        return this.createName(string, oid).canonicalize(oid2);
    }

    public org.ietf.jgss.GSSName createName(byte[] byArray, Oid oid) throws GSSException {
        return new GSSName(byArray, oid, this.kerberos);
    }

    public org.ietf.jgss.GSSName createName(byte[] byArray, Oid oid, Oid oid2) throws GSSException {
        return this.createName(byArray, oid).canonicalize(oid2);
    }

    static Oid createOid(String string) {
        try {
            return new Oid(string);
        }
        catch (GSSException gSSException) {
            throw new IllegalArgumentException(gSSException.getMessage());
        }
    }

    public Oid[] getMechs() {
        return MECHS;
    }

    public Oid[] getMechsForName(Oid oid) {
        if (oid == null || !oid.containedIn(TYPES)) {
            return null;
        }
        return MECHS;
    }

    public Oid[] getNamesForMech(Oid oid) throws GSSException {
        if (oid == null || !oid.equals(KRB5)) {
            throw new GSSException(1);
        }
        return TYPES;
    }
}

