/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.jgss;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;

public class Oid {
    private String strOid;
    private com.dstc.security.asn1.Oid asn1Oid;

    public Oid(InputStream inputStream) throws GSSException {
        try {
            this.asn1Oid = (com.dstc.security.asn1.Oid)Asn1.getAsn1(inputStream);
            this.strOid = this.asn1Oid.getOid();
        }
        catch (IOException iOException) {
            throw new GSSException(13, -1, iOException.toString());
        }
    }

    public Oid(String string) throws GSSException {
        if (string == null) {
            throw new GSSException(13);
        }
        this.strOid = string;
        this.asn1Oid = new com.dstc.security.asn1.Oid(this.strOid);
    }

    public Oid(byte[] byArray) throws GSSException {
        try {
            this.asn1Oid = (com.dstc.security.asn1.Oid)Asn1.getAsn1(byArray);
            this.strOid = this.asn1Oid.getOid();
        }
        catch (Asn1Exception asn1Exception) {
            throw new GSSException(13, -1, asn1Exception.toString());
        }
    }

    public boolean containedIn(Oid[] oidArray) {
        if (oidArray != null) {
            int n = 0;
            int n2 = oidArray.length;
            while (n < n2) {
                if (this.equals(oidArray[n])) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    static Oid create(String string) {
        try {
            return new Oid(string);
        }
        catch (GSSException gSSException) {
            throw new IllegalArgumentException(gSSException.getMessage());
        }
    }

    public boolean equals(Object object) {
        return object != null && object.getClass().equals(this.getClass()) && Oid.equals(((Oid)object).strOid, this.strOid);
    }

    static final boolean equals(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    public byte[] getDER() throws GSSException {
        try {
            return this.asn1Oid.getEncoded();
        }
        catch (Asn1Exception asn1Exception) {
            throw new GSSException(13, -1, asn1Exception.toString());
        }
    }

    public int hashCode() {
        return this.strOid.hashCode();
    }

    public String toString() {
        return this.strOid;
    }
}

