/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.ssl;

import com.dstc.security.ssl.SSLSignature;
import java.security.MessageDigest;
import java.security.ProviderException;
import java.security.Signature;
import java.security.SignatureException;

class RSASignature
extends SSLSignature {
    private MessageDigest md5;
    private MessageDigest sha;

    RSASignature() {
        try {
            this.sig = Signature.getInstance("RawRSA");
            this.md5 = MessageDigest.getInstance("MD5");
            this.sha = MessageDigest.getInstance("SHA");
        }
        catch (Exception exception) {
            throw new ProviderException(exception.getMessage());
        }
    }

    protected void setData(byte[] byArray, int n, int n2) throws SignatureException {
        this.sha.update(byArray, n, n2);
        this.md5.update(byArray, n, n2);
        this.sig.update(this.md5.digest());
        this.sig.update(this.sha.digest());
    }

    protected void setRandom(byte[] byArray, byte[] byArray2) {
        this.sha.reset();
        this.sha.update(byArray);
        this.sha.update(byArray2);
        this.md5.reset();
        this.md5.update(byArray);
        this.md5.update(byArray2);
    }
}

