/*
 * Decompiled with CFR 0.152.
 */
package javax.security.cert;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.Principal;
import java.util.Date;
import javax.security.cert.Certificate;
import javax.security.cert.CertificateException;
import javax.security.cert.CertificateExpiredException;
import javax.security.cert.CertificateNotYetValidException;
import javax.security.cert.X509CertImpl;

public abstract class X509Certificate
extends Certificate {
    public abstract void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException;

    public abstract void checkValidity(Date var1) throws CertificateExpiredException, CertificateNotYetValidException;

    public static final X509Certificate getInstance(InputStream inputStream) throws CertificateException {
        return X509CertImpl.getCert(inputStream);
    }

    public static final X509Certificate getInstance(byte[] byArray) throws CertificateException {
        return X509Certificate.getInstance(new ByteArrayInputStream(byArray));
    }

    public abstract Principal getIssuerDN();

    public abstract Date getNotAfter();

    public abstract Date getNotBefore();

    public abstract BigInteger getSerialNumber();

    public abstract String getSigAlgName();

    public abstract String getSigAlgOID();

    public abstract byte[] getSigAlgParams();

    public abstract Principal getSubjectDN();

    public abstract int getVersion();
}

