/*
 * Decompiled with CFR 0.152.
 */
package com.dstc.security.x509gen;

import com.dstc.security.asn1.Asn1;
import com.dstc.security.asn1.Asn1Exception;
import com.dstc.security.asn1.BitString;
import com.dstc.security.asn1.Sequence;
import com.dstc.security.asn1.UTCTime;
import com.dstc.security.common.AlgorithmId;
import com.dstc.security.common.OID;
import com.dstc.security.common.X500Name;
import com.dstc.security.x509.Extension;
import com.dstc.security.x509.Extensions;
import com.dstc.security.x509gen.TbsCertList;
import com.dstc.security.x509gen.X509CRLEntry;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.util.Date;
import java.util.Set;
import java.util.Vector;

public class X509CRL
extends com.dstc.security.x509.X509CRL {
    public static final int VERSION_2 = 1;
    private Signature sig;

    public X509CRL(X500Name x500Name, Signature signature) {
        this.sig = signature;
        this.tbsCertList = new TbsCertList(signature.getAlgorithm(), x500Name);
        this.sigAlg = new AlgorithmId(OID.getAlgOid(signature.getAlgorithm()));
    }

    public void addCRLExtension(Extension extension) {
        ((TbsCertList)this.tbsCertList).addExtension(extension);
    }

    public void addRevokedCert(BigInteger bigInteger) {
        this.addRevokedCert(bigInteger, new Date(), null);
    }

    public void addRevokedCert(BigInteger bigInteger, Extensions extensions) {
        this.addRevokedCert(bigInteger, new Date(), extensions);
    }

    public void addRevokedCert(BigInteger bigInteger, Date date) {
        this.addRevokedCert(bigInteger, date, null);
    }

    public void addRevokedCert(BigInteger bigInteger, Date date, Extensions extensions) {
        ((TbsCertList)this.tbsCertList).addRevokedCert(new X509CRLEntry(bigInteger, new UTCTime(date), extensions));
    }

    public void addRevokedCert(java.security.cert.X509CRLEntry x509CRLEntry) {
        X509CRLEntry x509CRLEntry2 = null;
        try {
            x509CRLEntry2 = new X509CRLEntry(Asn1.getAsn1(x509CRLEntry.getEncoded()));
        }
        catch (Asn1Exception asn1Exception) {
        }
        catch (IOException iOException) {
        }
        catch (CRLException cRLException) {}
        ((TbsCertList)this.tbsCertList).addRevokedCert(x509CRLEntry2);
    }

    public void deleteRevokedCert(BigInteger bigInteger) {
        ((TbsCertList)this.tbsCertList).deleteRevokedCert(bigInteger);
    }

    public void setCRLExtensions(Vector vector) {
        ((TbsCertList)this.tbsCertList).setExtensions(vector);
    }

    public void setNextUpdate(Date date) {
        ((TbsCertList)this.tbsCertList).setNextUpdate(date);
    }

    public void setRevokedCerts(Set set) {
        ((TbsCertList)this.tbsCertList).setRevokedCerts(set);
    }

    public void setThisUpdate(Date date) {
        ((TbsCertList)this.tbsCertList).setThisUpdate(date);
    }

    public void sign() throws SignatureException, Asn1Exception {
        this.asn1 = new Sequence();
        ((TbsCertList)this.tbsCertList).encode();
        this.asn1.add(this.tbsCertList.getAsn1());
        this.asn1.add(this.sigAlg.getAsn1());
        this.sig.update(((TbsCertList)this.tbsCertList).getAsn1().getEncoded());
        this.signature = this.sig.sign();
        this.asn1.add(new BitString(this.signature));
    }
}

