/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BSHIfStatement;
import bsh.EvalError;
import bsh.ForBodyNameSpace;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReturnControl;
import bsh.SimpleNode;

class BSHForStatement
extends SimpleNode
implements InterpreterConstants {
    public boolean hasForInit;
    public boolean hasExpression;
    public boolean hasForUpdate;
    private SimpleNode forInit;
    private SimpleNode expression;
    private SimpleNode forUpdate;
    private SimpleNode statement;
    private boolean parsed;

    BSHForStatement(int n) {
        super(n);
    }

    public Object eval(NameSpace nameSpace, Interpreter interpreter) throws EvalError {
        int n = 0;
        if (this.hasForInit) {
            this.forInit = (SimpleNode)this.jjtGetChild(n++);
        }
        if (this.hasExpression) {
            this.expression = (SimpleNode)this.jjtGetChild(n++);
        }
        if (this.hasForUpdate) {
            this.forUpdate = (SimpleNode)this.jjtGetChild(n++);
        }
        if (n < this.jjtGetNumChildren()) {
            this.statement = (SimpleNode)this.jjtGetChild(n);
        }
        NameSpace nameSpace2 = null;
        if (this.hasForInit) {
            nameSpace2 = new NameSpace("ForInitNameSpace");
            this.forInit.eval(nameSpace2, interpreter);
        }
        ForBodyNameSpace forBodyNameSpace = new ForBodyNameSpace(nameSpace, nameSpace2);
        while (!this.hasExpression || BSHIfStatement.evaluateCondition(this.expression, forBodyNameSpace, interpreter)) {
            Object object;
            boolean bl = false;
            if (this.statement != null && (object = this.statement.eval(forBodyNameSpace, interpreter)) instanceof ReturnControl) {
                switch (((ReturnControl)object).kind) {
                    case 41: {
                        return object;
                    }
                    case 19: {
                        break;
                    }
                    case 12: {
                        bl = true;
                    }
                }
            }
            if (bl) break;
            if (!this.hasForUpdate) continue;
            this.forUpdate.eval(forBodyNameSpace, interpreter);
        }
        return Primitive.VOID;
    }
}

