/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.BshMethod;
import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterError;
import bsh.LHS;
import bsh.Name;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.ReflectError;
import bsh.This;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

class Reflect {
    static /* synthetic */ Class class$bsh$Interpreter;

    Reflect() {
    }

    public static Object invokeMethod(Interpreter interpreter, Name name, Object[] objectArray) throws EvalError, ReflectError, InvocationTargetException {
        if (!Name.isCompound(name.value)) {
            return Reflect.invokeLocalMethod(interpreter, name, objectArray);
        }
        Name name2 = new Name(name.namespace, Name.prefix(name.value));
        String string = Name.suffix(name.value, 1);
        Object object = name2.toObject(interpreter);
        if (object == Primitive.VOID) {
            throw new EvalError("Method invocation on void: " + name);
        }
        if (!(object instanceof Name.ClassIdentifier)) {
            if (object instanceof Primitive) {
                if (object == Primitive.NULL) {
                    throw new EvalError("Null pointer error...");
                }
                interpreter.error("Attempt to access method on primitive... allowing bsh.Primitive to peek through for debugging");
            }
            return Reflect.invokeObjectMethod(interpreter, object, string, objectArray);
        }
        Interpreter.debug("invokeMethod: trying static - " + name2);
        Class clazz = ((Name.ClassIdentifier)object).getTargetClass();
        if (clazz != null) {
            return Reflect.invokeStaticMethod(clazz, string, objectArray);
        }
        throw new EvalError("unknown target: " + name2);
    }

    public static Object invokeObjectMethod(Interpreter interpreter, Object object, String string, Object[] objectArray) throws ReflectError, InvocationTargetException, EvalError {
        Interpreter.debug("invoke Method " + string + " on object " + object + " with args (");
        if (object instanceof This) {
            NameSpace nameSpace = ((This)object).namespace;
            BshMethod bshMethod = nameSpace.getMethod(string);
            if (bshMethod != null) {
                return bshMethod.invokeDeclaredMethod(objectArray, interpreter);
            }
            bshMethod = nameSpace.getMethod("invoke");
            if (bshMethod != null) {
                return bshMethod.invokeDeclaredMethod(new Object[]{string, objectArray}, interpreter);
            }
            throw new EvalError("No locally declared method: " + string + " in namespace: " + nameSpace);
        }
        return Reflect.invokeMethod(object.getClass(), object, string, objectArray);
    }

    public static Object invokeStaticMethod(Class clazz, String string, Object[] objectArray) throws ReflectError, InvocationTargetException {
        Interpreter.debug("invoke static Method");
        return Reflect.invokeMethod(clazz, null, string, objectArray);
    }

    public static Object getIndex(Object object, int n) throws ReflectError {
        try {
            Object object2 = Array.get(object, n);
            return Reflect.wrapPrimitive(object2, object.getClass().getComponentType());
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static void setIndex(Object object, int n, Object object2) throws ReflectError {
        try {
            object2 = Reflect.unwrapPrimitive(object2);
            Array.set(object, n, object2);
        }
        catch (Exception exception) {
            throw new ReflectError("Array access:" + exception);
        }
    }

    public static Object getStaticField(Class clazz, String string) throws ReflectError {
        return Reflect.getFieldValue(clazz, null, string);
    }

    public static Object getObjectField(Object object, String string) throws ReflectError {
        if (object instanceof This) {
            return ((This)object).namespace.getVariable(string);
        }
        return Reflect.getFieldValue(object.getClass(), object, string);
    }

    static LHS getLHSStaticField(Class clazz, String string) throws ReflectError {
        Field field = Reflect.getField(clazz, string);
        return new LHS(field);
    }

    static LHS getLHSObjectField(Object object, String string) throws ReflectError {
        if (object instanceof This) {
            return new LHS(((This)object).namespace, string);
        }
        Field field = Reflect.getField(object.getClass(), string);
        return new LHS(object, field);
    }

    private static Object getFieldValue(Class clazz, Object object, String string) throws ReflectError {
        try {
            Field field = Reflect.getField(clazz, string);
            if (field == null) {
                throw new ReflectError("internal error 234423");
            }
            Object object2 = field.get(object);
            Class<?> clazz2 = field.getType();
            return Reflect.wrapPrimitive(object2, clazz2);
        }
        catch (NullPointerException nullPointerException) {
            throw new ReflectError("???" + string + " is not a static field.");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Can't access field: " + string);
        }
    }

    private static Field getField(Class clazz, String string) throws ReflectError {
        try {
            return clazz.getField(string);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new ReflectError("No such field: " + string);
        }
    }

    private static Object invokeMethod(Class clazz, Object object, String string, Object[] objectArray) throws ReflectError, InvocationTargetException {
        if (objectArray == null) {
            objectArray = new Object[]{};
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + n + ") to method: " + string);
            }
            ++n;
        }
        Class<?> clazz2 = null;
        Object object2 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Reflect.unwrapPrimitives(objectArray);
        try {
            Method[] methodArray;
            try {
                methodArray = Reflect.findAccessibleMethod(clazz, string, classArray);
                object2 = methodArray.invoke(object, objectArray);
                if (object2 == null) {
                    object2 = Primitive.NULL;
                }
                clazz2 = methodArray.getReturnType();
            }
            catch (ReflectError reflectError) {
                Interpreter.debug("Exact method " + Reflect.methodString(string, classArray) + " not found in '" + clazz.getName() + "'");
            }
            if (object2 == null) {
                if (classArray.length == 0) {
                    throw new ReflectError("No args method " + Reflect.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
                }
                methodArray = clazz.getMethods();
                Method method = Reflect.findMostSpecificMethod(string, classArray, methodArray);
                if (method == null) {
                    method = Reflect.findExtendedMethod(string, objectArray, methodArray);
                }
                if (method == null) {
                    throw new ReflectError("Method " + Reflect.methodString(string, classArray) + " not found in class'" + clazz.getName() + "'");
                }
                method = Reflect.findAccessibleMethod(clazz, method.getName(), method.getParameterTypes());
                object2 = method.invoke(object, objectArray);
                clazz2 = method.getReturnType();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("Cannot access method " + Reflect.methodString(string, classArray) + " in '" + clazz.getName() + "' :" + illegalAccessException);
        }
        return Reflect.wrapPrimitive(object2, clazz2);
    }

    static Method findAccessibleMethod(Class clazz, String string, Class[] classArray) throws ReflectError {
        Method method = null;
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(clazz);
        while (vector.size() > 0) {
            Class<?>[] classArray2;
            Class clazz2 = (Class)vector.firstElement();
            vector.removeElementAt(0);
            if (Modifier.isPublic(clazz2.getModifiers())) {
                try {
                    method = clazz2.getDeclaredMethod(string, classArray);
                    if (method != null && Modifier.isPublic(method.getModifiers())) {
                        return method;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!clazz2.isInterface() && (classArray2 = clazz2.getSuperclass()) != null) {
                vector.addElement(classArray2);
            }
            classArray2 = clazz2.getInterfaces();
            int n = 0;
            while (n < classArray2.length) {
                vector.addElement(classArray2[n]);
                ++n;
            }
        }
        throw new ReflectError("Can't find publically accessible version of method: " + Reflect.methodString(string, classArray) + " in interfaces or class hierarchy of class " + clazz.getName());
    }

    private static Object wrapPrimitive(Object object, Class clazz) throws ReflectError {
        if (object == null) {
            return Primitive.NULL;
        }
        if (clazz == Void.TYPE) {
            return Primitive.VOID;
        }
        if (clazz.isPrimitive()) {
            if (object instanceof Number) {
                return new Primitive((Number)object);
            }
            if (object instanceof Boolean) {
                return new Primitive((Boolean)object);
            }
            if (object instanceof Character) {
                return new Primitive((Character)object);
            }
            throw new ReflectError("Something bad happened");
        }
        return object;
    }

    public static String methodString(String string, Class[] classArray) {
        Class clazz;
        StringBuffer stringBuffer = new StringBuffer(string + "(");
        int n = 0;
        while (n < classArray.length - 1) {
            clazz = classArray[n];
            stringBuffer.append((clazz == null ? "null" : clazz.getName()) + ", ");
            ++n;
        }
        if (classArray.length > 0) {
            clazz = classArray[classArray.length - 1];
            stringBuffer.append(clazz == null ? "null" : clazz.getName());
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    private static Class[] getTypes(Object[] objectArray) {
        if (objectArray == null) {
            return new Class[0];
        }
        Class[] classArray = new Class[objectArray.length];
        int n = 0;
        while (n < objectArray.length) {
            classArray[n] = objectArray[n] instanceof Primitive ? ((Primitive)objectArray[n]).getType() : objectArray[n].getClass();
            ++n;
        }
        return classArray;
    }

    private static void unwrapPrimitives(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = Reflect.unwrapPrimitive(objectArray[n]);
            ++n;
        }
    }

    private static Object unwrapPrimitive(Object object) {
        if (object instanceof Primitive) {
            return ((Primitive)object).getValue();
        }
        return object;
    }

    static Object invokeLocalMethod(Interpreter interpreter, Name name, Object[] objectArray) throws EvalError, ReflectError, InvocationTargetException {
        Interpreter.debug("invoke local method: " + name);
        BshMethod bshMethod = name.toLocalMethod();
        if (bshMethod != null) {
            return bshMethod.invokeDeclaredMethod(objectArray, interpreter);
        }
        Interpreter.debug("no locally declared method: " + name.value);
        String string = "commands/" + name.value + ".bsh";
        InputStream inputStream = (class$bsh$Interpreter == null ? (class$bsh$Interpreter = Reflect.class$("bsh.Interpreter")) : class$bsh$Interpreter).getResourceAsStream(string);
        if (inputStream != null) {
            Interpreter.debug("loading resource: " + string);
            if (interpreter == null) {
                throw new InterpreterError("2234432 interpreter = null");
            }
            interpreter.eval(inputStream, name.namespace, string);
            bshMethod = name.toLocalMethod();
            if (bshMethod != null) {
                return bshMethod.invokeDeclaredMethod(objectArray, interpreter);
            }
            throw new EvalError("Loaded resource: " + string + "had an error or did not contain the correct method");
        }
        string = "bsh.commands." + name.value;
        Class clazz = NameSpace.getAbsoluteClass(string);
        if (clazz == null) {
            throw new EvalError("Command not found: " + name);
        }
        Object[] objectArray2 = new Object[objectArray.length + 2];
        objectArray2[0] = interpreter;
        objectArray2[1] = name.namespace;
        System.arraycopy(objectArray, 0, objectArray2, 2, objectArray.length);
        try {
            return Reflect.invokeStaticMethod(clazz, "invoke", objectArray2);
        }
        catch (ReflectError reflectError) {
            Interpreter.debug("invoke command args error:" + reflectError);
            try {
                String string2 = (String)Reflect.invokeStaticMethod(clazz, "usage", null);
                interpreter.println(string2);
                return Primitive.VOID;
            }
            catch (ReflectError reflectError2) {
                Interpreter.debug("usage threw: " + reflectError2);
                throw new EvalError("Wrong number or type of args for command");
            }
        }
    }

    static Object constructObject(Class clazz, Object[] objectArray) throws ReflectError, InvocationTargetException {
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == Primitive.VOID) {
                throw new ReflectError("Attempt to pass void argument (position " + n + ") to constructor for: " + clazz);
            }
            ++n;
        }
        Constructor constructor = null;
        Object var4_4 = null;
        Class[] classArray = Reflect.getTypes(objectArray);
        Reflect.unwrapPrimitives(objectArray);
        try {
            constructor = clazz.getConstructor(classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor == null && classArray.length == 0) {
            throw new ReflectError("No args constructor not found in class'" + clazz.getName() + "'");
        }
        if (constructor == null) {
            if (classArray.length == 0) {
                throw new ReflectError("No args constructor not found in class'" + clazz.getName() + "'");
            }
            Constructor[] constructorArray = clazz.getConstructors();
            constructor = Reflect.findMostSpecificConstructor(classArray, constructorArray);
            if (constructor == null) {
                constructor = Reflect.findExtendedConstructor(objectArray, constructorArray);
            }
            if (constructor == null) {
                throw new ReflectError("Can't find constructor");
            }
        }
        try {
            var4_4 = constructor.newInstance(objectArray);
        }
        catch (InstantiationException instantiationException) {
            throw new ReflectError("the class is abstract ");
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ReflectError("we don't have permission to create an instance");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ReflectError("the number of arguments was wrong");
        }
        if (var4_4 == null) {
            throw new ReflectError("couldn't construct the object");
        }
        return var4_4;
    }

    static Method findMostSpecificMethod(String string, Class[] classArray, Method[] methodArray) {
        Class[] classArray2 = null;
        Method method = null;
        Interpreter.debug("Find most specific method for " + Reflect.methodString("args", classArray));
        int n = 0;
        while (n < methodArray.length) {
            Class[] classArray3 = methodArray[n].getParameterTypes();
            if (string.equals(methodArray[n].getName()) && Reflect.isAssignable(classArray, classArray3) && (classArray2 == null || Reflect.isAssignable(classArray3, classArray2))) {
                classArray2 = classArray3;
                method = methodArray[n];
            }
            ++n;
        }
        if (classArray2 != null) {
            Interpreter.debug("best match: " + method);
            return method;
        }
        Interpreter.debug("no match found");
        return null;
    }

    static Method findExtendedMethod(String string, Object[] objectArray, Method[] methodArray) {
        Object var3_3 = null;
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < methodArray.length) {
            Method method = methodArray[n];
            if (string.equals(method.getName())) {
                Class<?>[] classArray = method.getParameterTypes();
                try {
                    int n2 = 0;
                    while (n2 < classArray.length) {
                        objectArray2[n2] = NameSpace.checkAssignableFrom(objectArray[n2], classArray[n2]);
                        ++n2;
                    }
                    System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                    return method;
                }
                catch (EvalError evalError) {
                    // empty catch block
                }
            }
            ++n;
        }
        return null;
    }

    static Constructor findMostSpecificConstructor(Class[] classArray, Constructor[] constructorArray) {
        Class[] classArray2 = null;
        Constructor constructor = null;
        Interpreter.debug("Find most specific constructor for " + Reflect.methodString("args", classArray));
        int n = 0;
        while (n < constructorArray.length) {
            Class[] classArray3 = constructorArray[n].getParameterTypes();
            if (Reflect.isAssignable(classArray, classArray3) && (classArray2 == null || Reflect.isAssignable(classArray3, classArray2))) {
                classArray2 = classArray3;
                constructor = constructorArray[n];
            }
            ++n;
        }
        if (classArray2 != null) {
            Interpreter.debug("best match: " + constructor);
            return constructor;
        }
        Interpreter.debug("no match found");
        return null;
    }

    static Constructor findExtendedConstructor(Object[] objectArray, Constructor[] constructorArray) {
        Object var2_2 = null;
        Object[] objectArray2 = new Object[objectArray.length];
        int n = 0;
        while (n < constructorArray.length) {
            Constructor constructor = constructorArray[n];
            Class<?>[] classArray = constructor.getParameterTypes();
            try {
                int n2 = 0;
                while (n2 < classArray.length) {
                    objectArray2[n2] = NameSpace.checkAssignableFrom(objectArray[n2], classArray[n2]);
                    ++n2;
                }
                System.arraycopy(objectArray2, 0, objectArray, 0, objectArray.length);
                return constructor;
            }
            catch (EvalError evalError) {
                ++n;
            }
        }
        return null;
    }

    static boolean isAssignable(Class[] classArray, Class[] classArray2) {
        if (classArray.length != classArray2.length) {
            return false;
        }
        int n = 0;
        while (n < classArray.length) {
            if (classArray[n] == null) {
                if (classArray2[n].isPrimitive()) {
                    return false;
                }
            } else if (!Reflect.isAssignableFrom(classArray2[n], classArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    static boolean isAssignableFrom(Class clazz, Class clazz2) {
        if (clazz.isPrimitive() && clazz2.isPrimitive()) {
            if (clazz == clazz2) {
                return true;
            }
            if (clazz2 == Byte.TYPE && (clazz == Short.TYPE || clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Short.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Character.TYPE && (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Integer.TYPE && (clazz == Long.TYPE || clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Long.TYPE && (clazz == Float.TYPE || clazz == Double.TYPE)) {
                return true;
            }
            if (clazz2 == Float.TYPE && clazz == Double.TYPE) {
                return true;
            }
        } else if (clazz.isAssignableFrom(clazz2)) {
            return true;
        }
        return false;
    }

    public static Object getObjectProperty(Object object, String string) throws EvalError, ReflectError {
        String string2 = "get" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Object[] objectArray = new Object[]{};
        Interpreter.debug("property access: ");
        try {
            return Reflect.invokeObjectMethod(null, object, string2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EvalError("Property accessor threw exception!");
        }
    }

    public static void setObjectProperty(Object object, String string, Object object2) throws ReflectError, EvalError {
        String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
        Object[] objectArray = new Object[]{object2};
        Interpreter.debug("property access: ");
        try {
            Reflect.invokeObjectMethod(null, object, string2, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new EvalError("Property accessor threw exception!");
        }
    }

    public static String normalizeClassName(Class clazz) {
        if (!clazz.isArray()) {
            return clazz.getName();
        }
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append(Reflect.getArrayBaseType(clazz).getName());
            int n = 0;
            while (n < Reflect.getArrayDimensions(clazz)) {
                stringBuffer.append("[]");
                ++n;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return stringBuffer.toString();
    }

    public static int getArrayDimensions(Class clazz) {
        if (!clazz.isArray()) {
            return 0;
        }
        return clazz.getName().lastIndexOf(91) + 1;
    }

    public static Class getArrayBaseType(Class clazz) throws ReflectError {
        if (!clazz.isArray()) {
            throw new ReflectError("The class is not an array.");
        }
        return clazz.getComponentType();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

