/*
 * Decompiled with CFR 0.152.
 */
package bsh;

import bsh.EvalError;
import bsh.Interpreter;
import bsh.InterpreterConstants;
import bsh.InterpreterError;
import bsh.NameSpace;
import bsh.Primitive;
import bsh.Reflect;
import bsh.ReflectError;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Hashtable;

class LHS
implements InterpreterConstants,
Serializable {
    NameSpace nameSpace;
    static final int VARIABLE = 0;
    static final int FIELD = 1;
    static final int PROPERTY = 2;
    static final int INDEX = 3;
    int type;
    String varName;
    String propName;
    Field field;
    Object object;
    int index;

    LHS(NameSpace nameSpace, String string) {
        this.type = 0;
        this.varName = string;
        this.nameSpace = nameSpace;
    }

    LHS(Field field) {
        this.type = 1;
        this.object = null;
        this.field = field;
    }

    LHS(Object object, Field field) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 1;
        this.object = object;
        this.field = field;
    }

    LHS(Object object, String string) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 2;
        this.object = object;
        this.propName = string;
    }

    LHS(Object object, int n) {
        if (object == null) {
            throw new NullPointerException("constructed empty LHS");
        }
        this.type = 3;
        this.object = object;
        this.index = n;
    }

    Object getValue() throws EvalError {
        if (this.type == 0) {
            return this.nameSpace.getVariable(this.varName);
        }
        if (this.type == 1) {
            try {
                return this.field.get(this.object);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new EvalError("Can't read field: " + this.field);
            }
        }
        if (this.type == 2) {
            try {
                return Reflect.getObjectProperty(this.object, this.propName);
            }
            catch (ReflectError reflectError) {
                Interpreter.debug(reflectError.getMessage());
                throw new EvalError("No such property: " + this.propName);
            }
        }
        if (this.type == 3) {
            try {
                return Reflect.getIndex(this.object, this.index);
            }
            catch (Exception exception) {
                throw new EvalError("Array access: " + exception);
            }
        }
        throw new InterpreterError("LHS type");
    }

    public Object assign(Object object) throws EvalError {
        if (this.type == 0) {
            this.nameSpace.setVariable(this.varName, object);
        } else {
            if (this.type == 1) {
                try {
                    if (object instanceof Primitive) {
                        object = ((Primitive)object).getValue();
                    }
                    this.field.set(this.object, object);
                    return object;
                }
                catch (NullPointerException nullPointerException) {
                    throw new EvalError("LHS not a static field.");
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new EvalError("LHS can't access field.");
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new EvalError("Argument type mismatch");
                }
            }
            if (this.type == 2) {
                if (this.object instanceof Hashtable) {
                    ((Hashtable)this.object).put(this.propName, object);
                } else {
                    try {
                        Reflect.setObjectProperty(this.object, this.propName, object);
                    }
                    catch (ReflectError reflectError) {
                        Interpreter.debug("Assignment: " + reflectError.getMessage());
                        throw new EvalError("No such property: " + this.propName);
                    }
                }
            } else if (this.type == 3) {
                try {
                    Reflect.setIndex(this.object, this.index, object);
                }
                catch (Exception exception) {
                    throw new EvalError("Assignment: " + exception.getMessage());
                }
            }
        }
        return object;
    }

    public String toString() {
        return "LHS";
    }
}

