/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ClassBrowser
extends JSplitPane
implements ListSelectionListener,
TreeSelectionListener {
    JFrame frame;
    JInternalFrame iframe;
    Hashtable packages = new Hashtable();
    JList plist;
    JList classlist;
    JList mlist;
    JList conslist;
    String selectedPackage;
    Class selectedClass;
    JTextArea methodLine;
    String[] packagesList;
    String[] classesList;
    Method[] methodList;
    Constructor[] consList;
    JTree tree;

    public ClassBrowser() {
        super(0, true);
    }

    String[] split(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static String[] bubbleSort(String[] stringArray) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < stringArray.length) {
            vector.addElement(stringArray[n]);
            ++n;
        }
        int n2 = vector.size();
        boolean bl = true;
        while (bl) {
            bl = false;
            int n3 = 0;
            while (n3 < n2 - 1) {
                if (((String)vector.elementAt(n3)).compareTo((String)vector.elementAt(n3 + 1)) > 0) {
                    String string = (String)vector.elementAt(n3 + 1);
                    vector.removeElementAt(n3 + 1);
                    vector.insertElementAt(string, n3);
                    bl = true;
                }
                ++n3;
            }
        }
        Object[] objectArray = new String[n2];
        vector.copyInto(objectArray);
        return objectArray;
    }

    String[] splitClassname(String string) {
        String string2;
        String string3;
        int n;
        if ((string = string.replace('/', '.')).startsWith("class ")) {
            string = string.substring(6);
        }
        if (string.endsWith(".class")) {
            string = string.substring(0, string.length() - 6);
        }
        if ((n = string.lastIndexOf(".")) == -1) {
            string3 = string;
            string2 = "<unpackaged>";
        } else {
            string2 = string.substring(0, n);
            string3 = string.substring(n + 1);
        }
        return new String[]{string2, string3};
    }

    void addClass(String string) {
        String[] stringArray = this.splitClassname(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Vector<String> vector = (Vector<String>)this.packages.get(string2);
        if (vector == null) {
            vector = new Vector<String>();
            this.packages.put(string2, vector);
        }
        vector.addElement(string3);
    }

    void addJar(String string) throws IOException {
        ZipFile zipFile = new ZipFile(string);
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            if (!string2.endsWith(".class") || string2.indexOf(36) != -1) continue;
            this.addClass(string2);
        }
    }

    String[] toSortedList(Vector vector) {
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return ClassBrowser.bubbleSort((String[])objectArray);
    }

    void setClist(String string) {
        this.selectedPackage = string;
        Vector vector = (Vector)this.packages.get(string);
        if (vector == null) {
            return;
        }
        this.classesList = this.toSortedList(vector);
        this.classlist.setListData(this.classesList);
    }

    String[] parseMethods(Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = methodArray[n].getName();
            ++n;
        }
        return stringArray;
    }

    Method[] getPublicMethods(Method[] methodArray) {
        Vector<Method> vector = new Vector<Method>();
        int n = 0;
        while (n < methodArray.length) {
            if (Modifier.isPublic(methodArray[n].getModifiers())) {
                vector.addElement(methodArray[n]);
            }
            ++n;
        }
        Object[] objectArray = new Method[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    void setMlist(String string) {
        if (string == null) {
            this.mlist.setListData(new Object[0]);
            this.setConslist(null);
            this.setTree(null);
            return;
        }
        try {
            this.selectedClass = Class.forName(this.selectedPackage + "." + string);
        }
        catch (Exception exception) {
            System.out.println(exception);
            return;
        }
        this.methodList = this.getPublicMethods(this.selectedClass.getDeclaredMethods());
        this.mlist.setListData(this.parseMethods(this.methodList));
        this.setTree(this.selectedClass);
        this.setConslist(this.selectedClass);
    }

    void setConslist(Class clazz) {
        if (clazz == null) {
            this.conslist.setListData(new Object[0]);
            return;
        }
        this.consList = clazz.getConstructors();
        this.conslist.setListData(this.consList);
    }

    void setMethodLine(Object object) {
        this.methodLine.setText(object == null ? "" : object.toString());
    }

    void setTree(Class clazz) {
        if (clazz == null) {
            this.tree.setModel(null);
            return;
        }
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        do {
            DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(clazz.toString());
            if (defaultMutableTreeNode2 != null) {
                defaultMutableTreeNode3.add(defaultMutableTreeNode2);
            } else {
                defaultMutableTreeNode = defaultMutableTreeNode3;
            }
            defaultMutableTreeNode2 = defaultMutableTreeNode3;
        } while ((clazz = clazz.getSuperclass()) != null);
        this.tree.setModel(new DefaultTreeModel(defaultMutableTreeNode2));
        TreeNode treeNode = defaultMutableTreeNode.getParent();
        if (treeNode != null) {
            TreePath treePath = new TreePath(((DefaultTreeModel)this.tree.getModel()).getPathToRoot(treeNode));
            this.tree.expandPath(treePath);
        }
    }

    JPanel labeledPane(JComponent jComponent, String string) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add("Center", jComponent);
        jPanel.add("North", new JLabel(string, 0));
        return jPanel;
    }

    public void init() {
        String string = System.getProperty("java.class.path");
        String[] stringArray = this.split(string, File.pathSeparator);
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].endsWith(".jar") || stringArray[n].endsWith(".zip")) {
                try {
                    System.out.println("Adding classes: " + stringArray[n]);
                    this.addJar(stringArray[n]);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n;
        }
        if (this.packages.get("java.lang") == null) {
            try {
                this.addJar(System.getProperty("java.home") + "/lib/rt.jar");
            }
            catch (IOException iOException) {
                System.out.println("Can't find core classes....");
            }
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.packages.keys();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        this.packagesList = this.toSortedList(vector);
        this.plist = new JList<String>(this.packagesList);
        this.plist.addListSelectionListener(this);
        this.classlist = new JList();
        this.classlist.addListSelectionListener(this);
        this.mlist = new JList();
        this.mlist.addListSelectionListener(this);
        this.conslist = new JList();
        this.conslist.addListSelectionListener(this);
        JSplitPane jSplitPane = new JSplitPane(0, true, this.labeledPane(new JScrollPane(this.mlist), "Methods"), this.labeledPane(new JScrollPane(this.conslist), "Constructors"));
        JSplitPane jSplitPane2 = new JSplitPane(1, true, this.labeledPane(new JScrollPane(this.classlist), "Classes"), jSplitPane);
        jSplitPane2 = new JSplitPane(1, true, this.labeledPane(new JScrollPane(this.plist), "Packages"), jSplitPane2);
        JPanel jPanel = new JPanel(new BorderLayout());
        this.methodLine = new JTextArea(1, 60);
        this.methodLine.setEditable(false);
        this.methodLine.setLineWrap(true);
        this.methodLine.setWrapStyleWord(true);
        this.methodLine.setFont(new Font("Monospaced", 1, 14));
        this.methodLine.setMargin(new Insets(5, 5, 5, 5));
        this.methodLine.setBorder(BorderFactory.createRaisedBevelBorder());
        jPanel.add("North", this.methodLine);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.tree = new JTree();
        this.tree.addTreeSelectionListener(this);
        this.tree.setBorder(BorderFactory.createRaisedBevelBorder());
        this.setTree(null);
        jPanel2.add("Center", this.tree);
        jPanel.add("Center", jPanel2);
        jPanel.setPreferredSize(new Dimension(150, 150));
        this.setTopComponent(jSplitPane2);
        this.setBottomComponent(jPanel);
    }

    public static void main(String[] stringArray) {
        ClassBrowser classBrowser = new ClassBrowser();
        classBrowser.init();
        JFrame jFrame = new JFrame("BeanShell Class Browser v0.7");
        jFrame.getContentPane().add("Center", classBrowser);
        classBrowser.setFrame(jFrame);
        jFrame.pack();
        jFrame.show();
    }

    public void setFrame(JFrame jFrame) {
        this.frame = jFrame;
    }

    public void setFrame(JInternalFrame jInternalFrame) {
        this.iframe = jInternalFrame;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.driveToClass(treeSelectionEvent.getPath().getLastPathComponent().toString());
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getSource() == this.plist) {
            String string = (String)this.plist.getSelectedValue();
            this.setClist(string);
        } else if (listSelectionEvent.getSource() == this.classlist) {
            String string = (String)this.classlist.getSelectedValue();
            this.setMlist(string);
        } else if (listSelectionEvent.getSource() == this.mlist) {
            int n = this.mlist.getSelectedIndex();
            if (n == -1) {
                this.setMethodLine(null);
            } else {
                this.setMethodLine(this.methodList[n]);
            }
        } else if (listSelectionEvent.getSource() == this.conslist) {
            int n = this.conslist.getSelectedIndex();
            if (n == -1) {
                this.setMethodLine(null);
            } else {
                this.setMethodLine(this.consList[n]);
            }
        }
    }

    public void driveToClass(String string) {
        String[] stringArray = this.splitClassname(string);
        String string2 = stringArray[0];
        String string3 = stringArray[1];
        Vector vector = (Vector)this.packages.get(string2);
        if (vector == null) {
            return;
        }
        boolean bl = false;
        int n = 0;
        while (n < this.packagesList.length) {
            if (this.packagesList[n].equals(string2)) {
                this.plist.setSelectedIndex(n);
                this.plist.ensureIndexIsVisible(n);
                bl = true;
                break;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        int n2 = 0;
        while (n2 < this.classesList.length) {
            if (this.classesList[n2].equals(string3)) {
                this.classlist.setSelectedIndex(n2);
                this.classlist.ensureIndexIsVisible(n2);
                break;
            }
            ++n2;
        }
    }

    public void toFront() {
        if (this.frame != null) {
            this.frame.toFront();
        } else if (this.iframe != null) {
            this.iframe.toFront();
        }
    }
}

