/*
 * Decompiled with CFR 0.152.
 */
package bsh.util;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;
import java.util.StringTokenizer;

class HttpdConnection
extends Thread {
    Socket client;
    DataInputStream din;
    OutputStream out;
    PrintStream pout;
    boolean isHttp1;

    HttpdConnection(Socket socket) {
        this.client = socket;
        this.setPriority(4);
    }

    public void run() {
        try {
            Object object;
            this.din = new DataInputStream(this.client.getInputStream());
            this.out = this.client.getOutputStream();
            this.pout = new PrintStream(this.out);
            String string = this.din.readLine();
            if (string.toLowerCase().indexOf("http/1.") != -1) {
                while (!((String)(object = this.din.readLine())).equals("") && object != null) {
                }
                this.isHttp1 = true;
            }
            if (((StringTokenizer)(object = new StringTokenizer(string))).countTokens() < 2) {
                this.error(400, "Bad Request");
            } else {
                String string2 = ((StringTokenizer)object).nextToken();
                if (string2.equals("GET")) {
                    this.serveFile(((StringTokenizer)object).nextToken());
                } else {
                    this.error(400, "Bad Request");
                }
            }
            this.client.close();
        }
        catch (IOException iOException) {
            System.out.println("I/O error " + iOException);
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void serveFile(String string) throws FileNotFoundException, IOException {
        if (string.equals("/")) {
            string = "/bsh/util/lib/remote.html";
        }
        try {
            this.sendFileData(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.error(404, "Object Not Found");
        }
    }

    private void sendFileData(String string) throws IOException, FileNotFoundException {
        InputStream inputStream = this.getClass().getResourceAsStream(string);
        if (inputStream == null) {
            throw new FileNotFoundException(string);
        }
        byte[] byArray = new byte[inputStream.available()];
        inputStream.read(byArray);
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 200 Document follows");
            if (string.endsWith(".gif")) {
                this.pout.println("Content-type: image/gif");
            } else {
                this.pout.println("Content-type: text/html");
            }
            this.pout.println("Content-length: " + byArray.length + "\n");
        }
        this.out.write(byArray);
        this.out.flush();
    }

    private void error(int n, String string) {
        string = "<html><h1>" + string + "</h1></html>";
        if (this.isHttp1) {
            this.pout.println("HTTP/1.0 " + n + " " + string);
            this.pout.println("Content-type: text/html");
            this.pout.println("Content-length: " + string.length() + "\n");
        }
        this.pout.println(string);
    }
}

