;;; jde-which-method.el --- Print current method in mode line

;; Copyright (C) 1994, 1997, 1998 Free Software Foundation, Inc.

;; Author: Paul Kinnucan (paulk@mathworks.com)
;; Inspired by Alex Rezinsky's which-func package.
;; Keywords: mode-line, tools

;; This file is not part of GNU Emacs.

;; GNU Emacs is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU Emacs is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to the
;; Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; This package displays the name of the method at point
;; in the Emacs mode line. 

;;; History:

;;  $Log: jde-which-method.el,v $
;;  Revision 1.3  2000/09/05 04:42:22  paulk
;;  Fixed a number of bugs.
;;
;;  Revision 1.2  2000/09/04 05:03:16  paulk
;;  Added test for existence of method map.
;;
;;  Revision 1.1  2000/08/31 05:27:49  paulk
;;  Initial revision.
;;

;;; Code:

;; Variables for customization
;; ---------------------------
;;  

(require 'jde-parse)


(defgroup jde-which-method nil
  "Mode to display the current function name in the modeline."
  :group 'jde
  :version "1.0")

;;;###autoload
(defcustom jde-which-method-mode t
  "Enables the JDE's which method mode.
When which method mode is enabled, the current method name is
displayed in the mode line."
  :group 'jde-which-method
  :type  'boolean)

(defcustom jde-which-method-format '(" [" jde-which-method-current "]")
  "Format for displaying the function in the mode line."
  :group 'jde-which-method
  :type 'sexp)

(defcustom jde-mode-line-format 
  '("-" 
    mode-line-mule-info
    mode-line-modified
    mode-line-frame-identification
    mode-line-buffer-identification
    "   "
    global-mode-string
    "   %[(" mode-name mode-line-process minor-mode-alist "%n" ")%]--"
    (jde-which-method-mode
	 ("" jde-which-method-format "--"))
   (line-number-mode "L%l--")
   (column-number-mode "C%c--")
   (-3 . "%p")
   "-%-")
  "Format for the JDE source buffer mode line."
  :group 'jde
  :type 'sexp)
				 

;;; Code, nothing to customize below here
;;; -------------------------------------
;;;

(defvar jde-which-method-unknown "???"
  "String to display in the mode line when the current method is unknown.")

(defvar jde-which-method-current  jde-which-method-unknown)
(make-variable-buffer-local 'jde-which-method-current)

(defvar jde-which-method-current-point-loc -1)
(make-variable-buffer-local 'jde-which-method-current-point-loc)

(defvar jde-which-method-current-method-bounds (cons -1 -1))
(make-variable-buffer-local 'jde-which-method-current-method-bounds)


(defun jde-which-method-update ()
  (interactive)
  (condition-case info
      (let ((p (point)))
	(if (or
	     (= jde-which-method-current-point-loc p)
	     (and
	      (>= p (car jde-which-method-current-method-bounds))
	      (<= p (cdr jde-which-method-current-method-bounds))))
	    (setq jde-which-method-current-point p)
	  (let ((name (if jde-parse-the-method-map
			  (jde-parse-method-map-get-method-at jde-parse-the-method-map))))
	   (if name
	       (let* ((name-pair (car name))
		      (class (car name-pair))
		      (method (cdr name-pair))
		      (bounds (cdr name)))
		 (setq jde-which-method-current
		       (format "%s.%s" class method))
		 (setq jde-which-method-current-point-loc p)
		 (setq jde-which-method-current-method-bounds bounds))
	     (progn
	       (setq name (jde-parse-get-innermost-class-at-point))
	       (setq jde-which-method-current-point-loc p)
	       (setq jde-which-method-current-method-bounds (cons -1 -1))
	       (if name
		   (setq jde-which-method-current (car name))
		 (setq jde-which-method-current jde-which-method-unknown)))))))	   
    (error
     ;; (debug)
     (remove-hook 'post-command-hook 'jde-which-method-update)
     (message "Error in jde-which-method-update: %s" info))))

(provide 'jde-which-method)

;; jde-which-method.el ends here
