/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.Out;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Vector;

public class Skeleton {
    private static final int size = 21;
    private static final String NL = System.getProperty("line.separator");
    public static String[] line;
    private int pos;
    private PrintWriter out;
    static /* synthetic */ Class class$JFlex$Skeleton;

    public Skeleton(PrintWriter out) {
        this.out = out;
    }

    public void emitNext() {
        this.out.print(line[this.pos++]);
    }

    public static void makePrivate() {
        int i = 0;
        while (i < line.length) {
            Skeleton.line[i] = Skeleton.replace(" public ", " private ", line[i]);
            ++i;
        }
    }

    public static void readSkelFile(File skeletonFile) {
        if (skeletonFile == null) {
            throw new IllegalArgumentException("Skeleton file must not be null");
        }
        if (!skeletonFile.isFile() || !skeletonFile.canRead()) {
            Out.error(ErrorMessages.CANNOT_READ_SKEL, skeletonFile.toString());
            throw new GeneratorException();
        }
        Out.println(ErrorMessages.READING_SKEL, skeletonFile.toString());
        try {
            BufferedReader reader = new BufferedReader(new FileReader(skeletonFile));
            Skeleton.readSkel(reader);
        }
        catch (IOException e) {
            Out.error(ErrorMessages.SKEL_IO_ERROR);
            throw new GeneratorException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void readSkel(BufferedReader reader) throws IOException {
        String ln;
        Vector<String> lines = new Vector<String>();
        StringBuffer section = new StringBuffer();
        while ((ln = reader.readLine()) != null) {
            void var3_3;
            if (var3_3.startsWith("---")) {
                lines.addElement(section.toString());
                section.setLength(0);
                continue;
            }
            section.append((String)var3_3);
            section.append(NL);
        }
        if (section.length() > 0) {
            lines.addElement(section.toString());
        }
        if (lines.size() != 21) {
            Out.error(ErrorMessages.WRONG_SKELETON);
            throw new GeneratorException();
        }
        line = new String[21];
        int i = 0;
        while (i < 21) {
            Skeleton.line[i] = (String)lines.elementAt(i);
            ++i;
        }
    }

    public static String replace(String a, String b, String c) {
        StringBuffer result = new StringBuffer(c.length());
        int i = 0;
        int j = c.indexOf(a);
        while (j >= i) {
            result.append(c.substring(i, j));
            result.append(b);
            i = j + a.length();
            j = c.indexOf(a, i);
        }
        result.append(c.substring(i, c.length()));
        return result.toString();
    }

    public static void readDefault() {
        ClassLoader l = (class$JFlex$Skeleton == null ? (class$JFlex$Skeleton = Skeleton.class$("JFlex.Skeleton")) : class$JFlex$Skeleton).getClassLoader();
        URL url = l.getResource("JFlex/skeleton.default");
        if (url == null) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException();
        }
        try {
            InputStreamReader reader = new InputStreamReader(url.openStream());
            Skeleton.readSkel(new BufferedReader(reader));
        }
        catch (IOException e) {
            Out.error(ErrorMessages.SKEL_IO_ERROR_DEFAULT);
            throw new GeneratorException();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Skeleton.readDefault();
    }
}

