/*
 * Decompiled with CFR 0.152.
 */
package JFlex.tests;

import JFlex.Options;
import JFlex.Skeleton;
import JFlex.anttask.JFlexTask;
import java.io.File;
import java.io.IOException;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AntTaskTests
extends TestCase {
    private JFlexTask task;

    public AntTaskTests(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Options.setDefaults();
        this.task = new JFlexTask();
    }

    public void testPackageAndClass() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        Assert.assertEquals((String)this.task.getPackage(), (String)"JFlex");
        Assert.assertEquals((String)this.task.getClassName(), (String)"LexScan");
    }

    public void testPackageAndClassDefaults() throws IOException {
        this.task.setFile(new File("examples/simple/simple.flex"));
        this.task.findPackageAndClass();
        Assert.assertEquals((String)this.task.getPackage(), null);
        Assert.assertEquals((String)this.task.getClassName(), (String)"Yylex");
    }

    public void testDestdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setDestdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals((Object)Options.getDir(), (Object)new File(dir, "JFlex"));
    }

    public void testOutdir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        File dir = new File("src");
        this.task.setOutdir(dir);
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals((Object)Options.getDir(), (Object)dir);
    }

    public void testDefaultDir() throws IOException {
        this.task.setFile(new File("src/JFlex/LexScan.flex"));
        this.task.findPackageAndClass();
        this.task.normalizeOutdir();
        Assert.assertEquals((Object)Options.getDir(), (Object)new File("src/JFlex"));
    }

    public void testNomin() {
        Assert.assertFalse((boolean)Options.no_minimize);
        this.task.setNomin(true);
        Assert.assertTrue((boolean)Options.no_minimize);
    }

    public void testSkipMinimization() {
        Assert.assertFalse((boolean)Options.no_minimize);
        this.task.setSkipMinimization(true);
        Assert.assertTrue((boolean)Options.no_minimize);
    }

    public void testNobak() {
        Assert.assertFalse((boolean)Options.no_backup);
        this.task.setNobak(true);
        Assert.assertTrue((boolean)Options.no_backup);
    }

    public void testCodeGen() {
        this.task.setSwitch(true);
        Assert.assertEquals((int)Options.gen_method, (int)2);
        this.task.setTable(true);
        Assert.assertEquals((int)Options.gen_method, (int)1);
        this.task.setPack(true);
        Assert.assertEquals((int)Options.gen_method, (int)0);
    }

    public void testSkel() {
        this.task.setVerbose(false);
        this.task.setSkeleton(new File("src/skeleton.nested"));
        Assert.assertTrue((Skeleton.line[3].indexOf("java.util.Stack") > 0 ? 1 : 0) != 0);
    }

    public void testVerbose() {
        this.task.setVerbose(false);
        Assert.assertFalse((boolean)Options.verbose);
        this.task.setVerbose(true);
        Assert.assertTrue((boolean)Options.verbose);
    }

    public void testTime() {
        Assert.assertFalse((boolean)Options.time);
        this.task.setTimeStatistics(true);
        Assert.assertTrue((boolean)Options.time);
        this.task.setTime(false);
        Assert.assertFalse((boolean)Options.time);
    }

    public void testDot() {
        Assert.assertFalse((boolean)Options.dot);
        this.task.setDot(true);
        Assert.assertTrue((boolean)Options.dot);
        this.task.setGenerateDot(false);
        Assert.assertFalse((boolean)Options.dot);
    }

    public void testDump() {
        Assert.assertFalse((boolean)Options.dump);
        this.task.setDump(true);
        Assert.assertTrue((boolean)Options.dump);
    }

    public void testJlex() {
        Assert.assertFalse((boolean)Options.jlex);
        this.task.setJLex(true);
        Assert.assertTrue((boolean)Options.jlex);
    }
}

