/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.IntCharSet;
import JFlex.Interval;
import JFlex.Macros;
import JFlex.Out;
import JFlex.RegExp;
import JFlex.RegExp1;
import JFlex.RegExp2;
import JFlex.RegExps;
import java.io.File;
import java.util.Vector;

public final class SemCheck {
    private static Macros macros;
    private static char maxChar;

    public static void check(RegExps rs, Macros m, char max, File f) {
        macros = m;
        maxChar = max;
        boolean errors = false;
        int num = rs.getNum();
        int i = 0;
        while (i < num) {
            RegExp l;
            RegExp r = rs.getRegExp(i);
            if (!SemCheck.checkLookAhead(r, l = rs.getLookAhead(i))) {
                errors = true;
                Out.error(f, ErrorMessages.LOOKAHEAD_ERROR, rs.getLine(i), -1);
            }
            ++i;
        }
        if (errors) {
            throw new GeneratorException();
        }
    }

    private static boolean checkLookAhead(RegExp r1, RegExp r2) {
        return r2 == null || SemCheck.length(r1) > 0 || !SemCheck.last(r1).and(SemCheck.first(r2)).containsElements();
    }

    private static int length(RegExp re) {
        switch (re.type) {
            case 34: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l1 == l2) {
                    return l1;
                }
                return -1;
            }
            case 44: {
                RegExp2 r = (RegExp2)re;
                int l1 = SemCheck.length(r.r1);
                if (l1 < 0) {
                    return -1;
                }
                int l2 = SemCheck.length(r.r2);
                if (l2 < 0) {
                    return -1;
                }
                return l1 + l2;
            }
            case 32: 
            case 33: 
            case 35: {
                return -1;
            }
            case 39: 
            case 42: 
            case 43: {
                return 1;
            }
            case 40: {
                String content = (String)((RegExp1)re).content;
                return content.length();
            }
            case 41: {
                return SemCheck.length(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    private static boolean containsEpsilon(RegExp re) {
        switch (re.type) {
            case 34: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.containsEpsilon(r.r1) || SemCheck.containsEpsilon(r.r2);
            }
            case 44: {
                RegExp2 r = (RegExp2)re;
                if (SemCheck.containsEpsilon(r.r1)) {
                    return SemCheck.containsEpsilon(r.r2);
                }
                return false;
            }
            case 32: 
            case 35: {
                return true;
            }
            case 33: {
                return SemCheck.containsEpsilon((RegExp)((RegExp1)re).content);
            }
            case 39: 
            case 42: 
            case 43: {
                return false;
            }
            case 40: {
                return ((String)((RegExp1)re).content).length() <= 0;
            }
            case 41: {
                return SemCheck.containsEpsilon(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    private static IntCharSet first(RegExp re) {
        switch (re.type) {
            case 34: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.first(r.r1).add(SemCheck.first(r.r2));
            }
            case 44: {
                RegExp2 r = (RegExp2)re;
                if (SemCheck.containsEpsilon(r.r1)) {
                    return SemCheck.first(r.r1).add(SemCheck.first(r.r2));
                }
                return SemCheck.first(r.r1);
            }
            case 32: 
            case 33: 
            case 35: {
                return SemCheck.first((RegExp)((RegExp1)re).content);
            }
            case 42: {
                return new IntCharSet((Vector)((RegExp1)re).content);
            }
            case 43: {
                IntCharSet all = new IntCharSet(new Interval('\u0000', maxChar));
                IntCharSet set = new IntCharSet((Vector)((RegExp1)re).content);
                all.sub(set);
                return all;
            }
            case 39: {
                return new IntCharSet(((Character)((RegExp1)re).content).charValue());
            }
            case 40: {
                String content = (String)((RegExp1)re).content;
                if (content.length() > 0) {
                    return new IntCharSet(content.charAt(0));
                }
                return new IntCharSet();
            }
            case 41: {
                return SemCheck.first(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }

    private static IntCharSet last(RegExp re) {
        switch (re.type) {
            case 34: {
                RegExp2 r = (RegExp2)re;
                return SemCheck.last(r.r1).add(SemCheck.last(r.r2));
            }
            case 44: {
                RegExp2 r = (RegExp2)re;
                if (SemCheck.containsEpsilon(r.r2)) {
                    return SemCheck.last(r.r1).add(SemCheck.last(r.r2));
                }
                return SemCheck.last(r.r2);
            }
            case 32: 
            case 33: 
            case 35: {
                return SemCheck.last((RegExp)((RegExp1)re).content);
            }
            case 42: {
                return new IntCharSet((Vector)((RegExp1)re).content);
            }
            case 43: {
                IntCharSet all = new IntCharSet(new Interval('\u0000', maxChar));
                IntCharSet set = new IntCharSet((Vector)((RegExp1)re).content);
                all.sub(set);
                return all;
            }
            case 39: {
                return new IntCharSet(((Character)((RegExp1)re).content).charValue());
            }
            case 40: {
                String content = (String)((RegExp1)re).content;
                if (content.length() > 0) {
                    return new IntCharSet(content.charAt(content.length() - 1));
                }
                return new IntCharSet();
            }
            case 41: {
                return SemCheck.last(macros.getDefinition((String)((RegExp1)re).content));
            }
        }
        throw new Error("Unkown expression type " + re.type + " in " + re);
    }
}

