<?xml version="1.0"?>

<xsl:stylesheet version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
  xmlns="http://www.w3.org/TR/xhtml1/strict">

  <!--
    Let's start by declaring HOW this stylesheet must behave.
  -->
  <xsl:output method="html" indent="yes"
    doctype-public="-//W3C//DTD HTML 4.01//EN"
    doctype-system="http://www.w3.org/TR/html4/strict.dtd"/>

  <!-- Define default values for parameters -->
  <xsl:param name="styles" select="''"/>
  <xsl:param name="images" select="'../images'"/>
  <xsl:param name="homedoc" select="'../'"/>

  <!-- Defined variables (non-overrideable) -->
  <xsl:variable name="body-bg"       select="'#ffffff'"/>
  <xsl:variable name="body-fg"       select="'#000000'"/>
  <xsl:variable name="body-link"     select="'#525D76'"/>
  <xsl:variable name="banner-bg"     select="'#525D76'"/>
  <xsl:variable name="banner-fg"     select="'#ffffff'"/>
  <xsl:variable name="sub-banner-bg"     select="'#828DA6'"/>
  <xsl:variable name="sub-banner-fg"     select="'#ffffff'"/>
  <xsl:variable name="table-th-bg"   select="'#039acc'"/>
  <xsl:variable name="table-td-bg"   select="'#a0ddf0'"/>
  <xsl:variable name="gen-dev-doc"   select="'false'"/>

  <!--
    Match the ROOT of the source document and process its "document" element.
  -->
  <xsl:template match="/">
    <xsl:apply-templates select="document"/>
  </xsl:template>

  <!--
    Match the roote "document" element, let's prepare the layout of the whole
    page.
  -->
  <xsl:template match="document">
    <html>

      <!--
        This is the page header, we want a title from this document title
        the <meta> copyright statement and all authors in "meta" headers.
      -->
      <head>
        <title>
          <xsl:value-of select="properties/title"/>
        </title>
        <meta name="copyright" content="1999-2002 The Apache Software Foundation"/>
        <xsl:for-each select="properties/date">
          <xsl:variable name="date">
            <xsl:value-of select="."/>
          </xsl:variable>
          <meta name="last-changed" content="{$date}"/>
        </xsl:for-each>
         <xsl:for-each select="properties/author">
          <xsl:variable name="name">
            <xsl:value-of select="."/>
          </xsl:variable>
          <xsl:variable name="email">
            <xsl:value-of select="@email"/>
          </xsl:variable>
          <meta name="author" content="{$name}"/>
          <meta name="email" content="{$email}"/>
        </xsl:for-each>
        <link rel="stylesheet" type="text/css" href="{$styles}/style.css"/>
        <link rel="shortcut icon" href="{$images}/tomcat.ico"/>
      </head>

      <!--
        This describes the layout of the page
      -->
      <body bgcolor="{$body-bg}" text="{$body-fg}" alink="{$body-link}"
            vlink="{$body-link}" link="{$body-link}">
        <a name="TOP"/>

        <table border="0" cellspacing="0" cellpadding="0" width="100%">
          <!--
            An empty row (thank you stupid IE).
          -->
          <tr height="1">
            <td width="150" bgcolor="{$body-bg}" height="1" class="nil">
              <img src="{$images}/pixel.gif" border="0" width="150" height="1" vspace="0" hspace="0"/>
            </td>
            <td width="*" bgcolor="{$body-bg}" height="1" class="nil">
              <img src="{$images}/pixel.gif" border="0" width="370" height="1" vspace="0" hspace="0"/>
            </td>
          </tr>

          <!--
            Our first row contains the Jakarta and the JK logos.
          -->
          <tr>
            <td bgcolor="{$body-bg}" class="logo" colspan="2" width="*">
              <table border="0" cellspacing="0" cellpadding="0" width="100%">
                <tr>
                  <td align="left">
                    <img src="{$images}/jakarta.gif" border="0" width="505" height="48" align="left"/>
                  </td>
                  <td align="right">
                    <img src="{$images}/mod_jk.jpg" border="0" align="right"/>
                  </td>
                </tr>
              </table>
            </td>
          </tr>

          <!--
            A Turbine-style bar with links to the ASF, Jakarta and Tomcat.
          -->
          <tr>
            <td bgcolor="#999999" class="head" align="right" width="*" colspan="2">
              <nobr>
                <a class="head" href="http://www.apache.org/">
                  <xsl:text>Apache Software Foundation</xsl:text>
                </a> |
                <a class="head" href="http://jakarta.apache.org/">
                  <xsl:text>Jakarta Project</xsl:text>
                </a> |
                <a class="head" href="http://jakarta.apache.org/tomcat/">
                  <xsl:text>Apache Tomcat</xsl:text>
                </a>
              </nobr>
            </td>
          </tr>

          <!--
            Sidebar menu in a nested table and main content.
          -->
          <tr>
            <td bgcolor="#ffffff" width="150" valign="top">

              <!--
                This is the sidebar menu, we have links to all documents specified
                in "menu.idx", and if this is the current document, we go deeper
                and write an index of the sections as well.
              -->
              <table border="0" width="150" cellspacing="0" cellpadding="0" class="menu">
                <!-- Empty row, thanks IE -->
                <tr height="1">
                  <td width="10" bgcolor="#cccccc" height="1" class="nil">
                    <img src="{$images}/pixel.gif" border="0" width="10" height="1" vspace="0" hspace="0"/>
                  </td>
                  <td width="140" bgcolor="#cccccc" height="1" class="nil">
                    <img src="{$images}/pixel.gif" border="0" width="140" height="1" vspace="0" hspace="0"/>
                  </td>
                </tr>

                <!--
                  All the files we want to have processed in the final pages are
                  stored (in order) in a file called "menu.idx". We set a variable
                  name with the current URL, and then we process each "document"
                  within the index.
                -->
                <xsl:variable name="root" select="/"/>
                <xsl:for-each select="document('menu.idx')/index/section">
                  <tr height="6">
                  <td bgcolor="#d0d0d0" width="150" colspan="2">
                  <xsl:value-of select="@name"/>
                  </td>
                  </tr>
	                <xsl:for-each select="./document">
	                  <xsl:variable name="href" select="@href"/>
	                  <tr>
	                    <td bgcolor="#cccccc" width="150" colspan="2">
	                      <nobr>
	                        <a class="menu">
	                          <xsl:call-template name="converturi">
	                            <xsl:with-param name="href" select="@href"/>
	                          </xsl:call-template>
	                        </a>
	                      </nobr>
	                    </td>
	                  </tr>
	                  <tr height="2">
	                  </tr>

	                  <!--
	                    Slightly more complicated, we use the document-location function
	                    and compare against it to see whether we are in the same file or
	                    not. If we actually are, we expand to the "section" level.
	                  -->
	                  <xsl:if test="$root/document/properties/title = document(@href)/document/properties/title">
	                    <xsl:for-each select="document(@href)/document/section">
	                      <tr>
	                        <td bgcolor="#cccccc" width="10"/>
	                        <td bgcolor="#cccccc" width="140">
	                          <a class="menu" href="#{@name}">
	                            <xsl:value-of select="@name"/>
	                          </a>
	                        </td>
	                       </tr>
	                       <tr height="1">
	                      </tr>
	                    </xsl:for-each>
	                  </xsl:if>
                  </xsl:for-each>
                  <tr height="6"/>
                </xsl:for-each>

	            <xsl:if test="$gen-dev-doc = true">
                <!--
                  The last thing to put down in the index are the API docs,
                  both for C and for Java
                -->
                <tr height="6">
                <td bgcolor="#d0d0d0" width="150" colspan="2">
                Developpers
                </td>
                </tr>
                <tr>
                  <td bgcolor="#cccccc" width="150" colspan="2">
                    <nobr>
                      <a class="menu" href="./api-java/index.html">Java API Documentation</a>
                    </nobr>
                  </td>
                </tr>
                <tr>
                  <td bgcolor="#cccccc" width="150" colspan="2">
                    <nobr>
                      <a class="menu" href="./api-c/">C API Documentation</a>
                    </nobr>
                  </td>
                </tr>
	            </xsl:if>

              </table>
            </td>

            <!--
              Done with the sidebar, now, do we want some content as well or WHAT?
            -->
            <td bgcolor="#ffffff" width="*" valign="top" class="body">
              <xsl:apply-templates select="section"/>
            </td>
          </tr>
        </table>
      </body>
    </html>
  </xsl:template>

  <!--
    Match the "author" tag only in mode "header" (meaning that we have to
    process it for the HTML <head> element.
  -->
  <xsl:template match="author" mode="header">
    <meta name="author" content="{text()}"/>
    <meta name="email" content="{@email}"/>
  </xsl:template>

  <!--
    Present a canonical representation of an author.
  -->
  <xsl:template match="author">
    <a href="mailto:{@email}"><xsl:value-of select="text()"/></a>
  </xsl:template>

  <xsl:template match="section">
    <a name="{@name}">
      <table border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr>
          <td bgcolor="{$banner-bg}" class="section" valign="top" align="left">
            <img src="{$images}/corner.gif" valign="top" align="left" hspace="0" vspace="0" border="0"/>
              <xsl:if test="string-length(description/text()) = 0">
                <xsl:value-of select="@name"/>
              </xsl:if>
              <xsl:value-of select="description/text()"/>
          </td>
        </tr>
      </table>
    </a>
    <xsl:apply-templates select="subsection|p|ul|ol|img|screen|screendos|screen5250|todo"/>
    <br/>
  </xsl:template>

  <xsl:template match="subsection">
    <a name="sub_{@name}">
      <table border="0" cellspacing="0" cellpadding="0" width="100%">
        <tr>
          <td bgcolor="{$sub-banner-bg}" class="subsection" valign="top" align="left">
            <img src="{$images}/corner.gif" valign="top" align="left" hspace="0" vspace="0" border="0"/>
              <xsl:if test="string-length(description/text()) = 0">
                <xsl:value-of select="@name"/>
              </xsl:if>
              <xsl:value-of select="description/text()"/>
          </td>
        </tr>
      </table>
    </a>
    <xsl:apply-templates select="subsection|p|ul|ol|img|screen|screendos|screen5250|todo"/>
    <br/>
  </xsl:template>

  <xsl:template match="todo">
    <p class="todo">
      This paragraph has not been written yet, but <b>you</b> can contribute to it.
      <xsl:if test="string-length(@note) > 0">
        The original author left a note attached to this TO-DO item:
        <b><xsl:value-of select="@note"/></b>
      </xsl:if>
    </p>
  </xsl:template>

  <xsl:template match="p">
    <p class="section"><xsl:apply-templates select="author|code|source|screen|screendos|screen5250|table|ul|ol|br|b|a|text()"/></p>
  </xsl:template>

  <xsl:template match="b">
    <b><font color="#333333"><xsl:apply-templates select="text()"/></font></b>
  </xsl:template>

  <xsl:template match="br">
    <br/>
  </xsl:template>

  <xsl:template match="img">
    <p>
      <div align="center">
        <xsl:value-of select="@alt"/><br/>
        <img src="{@src}" alt="{@alt}" vspace="0" hspace="0" border="0"/>
      </div>
    </p>
  </xsl:template>

  <xsl:template match="ul">
    <ul><xsl:apply-templates select="li|ul|ol"/></ul>
  </xsl:template>

  <xsl:template match="ol">
    <ol><xsl:apply-templates select="li|ul|ol"/></ol>
  </xsl:template>

  <xsl:template match="li">
    <li><xsl:apply-templates select="br|b|a|ul|ol|text()"/></li>
  </xsl:template>

  <!-- JFC added -->
  <xsl:template match="table">
    <table border="0"><xsl:apply-templates select="tr"/></table>
  </xsl:template>

  <xsl:template match="tr">
    <tr><xsl:apply-templates select="th|td|td15|td13|td6|td5|td3|td2"/></tr>
  </xsl:template>

  <xsl:template match="th">
    <td bgcolor="{$table-th-bg}" valign="top" align="middle">
        <xsl:if test="@colspan">
            <xsl:attribute name="colspan">
            <xsl:value-of select="@colspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="b|a|text()"/>
    </td>
  </xsl:template>

  <xsl:template match="td">
    <td bgcolor="{$table-td-bg}" valign="top" align="left">
        <xsl:if test="@colspan">
            <xsl:attribute name="colspan">
            <xsl:value-of select="@colspan"/>
            </xsl:attribute>
        </xsl:if>
        <xsl:apply-templates select="b|a|text()"/>
    </td>
  </xsl:template>

  <xsl:template match="source">
    <pre class="section"><xsl:apply-templates select="text()"/></pre>
  </xsl:template>

  <xsl:template match="code">
    <b class="code"><xsl:apply-templates select="text()"/></b>
  </xsl:template>
  <!-- end JFC -->

  <xsl:template match="screen">
    <p class="screen">
      <div align="center">
        <table width="80%" border="1" cellspacing="0" cellpadding="2" bgcolor="#cccccc">
          <tr>
            <td bgcolor="#cccccc" align="left">
              <xsl:apply-templates select="note|wait|type|typenext|read"/>
            </td>
          </tr>
        </table>
      </div>
    </p>
  </xsl:template>
  
  <xsl:template match="screendos">
    <p class="screendos">
      <div align="center">
        <table width="80%" border="1" cellspacing="0" cellpadding="2" bgcolor="#000000">
          <tr>
            <td bgcolor="#000000" align="left">
              <xsl:apply-templates select="notedos|waitdos|typedos|typedosnext|readdos"/>
            </td>
          </tr>
        </table>
      </div>
    </p>
  </xsl:template>
  
  <xsl:template match="screen5250">
    <p class="screen5250">
      <div align="center">
        <table width="80%" border="1" cellspacing="0" cellpadding="2" bgcolor="#000000">
          <tr>
            <td bgcolor="#000000" align="left">
              <xsl:apply-templates select="note5250|wait5250|type5250|type5250next|read5250"/>
            </td>
          </tr>
        </table>
      </div>
    </p>
  </xsl:template>
  
  <!-- Unix look -->

  <xsl:template match="note">
    <div class="screen">
      <xsl:value-of select="text()"/>
    </div>
  </xsl:template>

  <xsl:template match="wait">
    <div class="screen">[...]</div>
  </xsl:template>

  <xsl:template match="type">
    <code>
      <nobr>
        <em class="screen">
          <xsl:text>[user@host] ~</xsl:text>
          <xsl:if test="string-length(@dir) > 0">
            <xsl:text>/</xsl:text>
            <xsl:value-of select="@dir"/>
          </xsl:if>
          <xsl:text> $ </xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screen"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="typenext">
    <code>
      <nobr>
        <em class="screen">        
          <xsl:text> </xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screen"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="read">
    <code class="screen">
      <nobr>
        <xsl:apply-templates select="text()|enter"/>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="enter">
    <b class="screen"><xsl:value-of select="text()"/></b>
  </xsl:template>

  <!-- DOS/Windows look -->

  <xsl:template match="notedos">
    <div class="screendos">
      <xsl:value-of select="text()"/>
    </div>
  </xsl:template>

  <xsl:template match="waitdos">
    <div class="screendos">[...]</div>
  </xsl:template>

  <xsl:template match="readdos">
    <code class="screendos">
      <nobr>
        <xsl:apply-templates select="text()|enterdos"/>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="typedos">
    <code>
      <nobr>
        <em class="screendos">
          <xsl:text>c:\</xsl:text>
          <xsl:if test="string-length(@dir) > 0">
            <xsl:text>/</xsl:text>
            <xsl:value-of select="@dir"/>
          </xsl:if>
          <xsl:text>></xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screendos"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="typedosnext">
    <code>
      <nobr>
        <em class="screendos">        
          <xsl:text> </xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screendos"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="enterdos">
    <b class="screendos"><xsl:value-of select="text()"/></b>
  </xsl:template>

  <!-- iSeries/5250 look -->

  <xsl:template match="note5250">
    <div class="screen5250">
      <xsl:value-of select="text()"/>
    </div>
  </xsl:template>

  <xsl:template match="wait5250">
    <div class="screen5250">[...]</div>
  </xsl:template>

  <xsl:template match="read5250">
    <code class="screen5250">
      <nobr>
        <xsl:apply-templates select="text()|enter5250"/>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="type5250">
    <code>
      <nobr>
        <em class="screen5250">
          <xsl:text>===></xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screen5250"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="type5250next">
    <code>
      <nobr>
        <em class="screen5250">        
          <xsl:text> </xsl:text>
        </em>
        <xsl:if test="string-length(text()) > 0">
          <b class="screen5250"><xsl:value-of select="text()"/></b>
        </xsl:if>
      </nobr>
    </code>
    <br/>
  </xsl:template>

  <xsl:template match="enter5250">
    <b class="screen5250"><xsl:value-of select="text()"/></b>
  </xsl:template>

  <xsl:template match="a">
    <b>
      <a>
        <xsl:call-template name="converturi">
          <xsl:with-param name="href" select="@href"/>
          <xsl:with-param name="text" select="text()"/>
          <xsl:with-param name="attr" select="'href'"/>
        </xsl:call-template>
      </a>
    </b>
  </xsl:template>

  <!--
    Convert the name of the matching "href" attribute (if needed) from
    "file.xml#anchor" to "file.html#anchor", and insert the title of
    the target document as the only text child of the resulting html
    <a /> tag. (Of course, don't convert fully qualified URIs).
  -->
  <xsl:template name="converturi">
    <xsl:param name="attr" select="'href'"/>
    <xsl:param name="href" select="''"/>
    <xsl:param name="text" select="''"/>

    <xsl:choose>
    
      <!--
        If the "href" parameter contains ":" this is most definitely an URL,
        therefore we need to quote it "as is" without translating its value.
        The text is either supplied, or it's the value of the URL itself
        (without the trailing anchor, if any).
      -->
      <xsl:when test="contains($href,':')">
        <xsl:attribute name="{$attr}"><xsl:value-of select="$href"/></xsl:attribute>
        <xsl:if test="string-length($text) = 0">
          <xsl:choose>
            <xsl:when test="contains($href,'#')">
              <xsl:value-of select="substring-before($href,'#')"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$href"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <xsl:value-of select="$text"/>
      </xsl:when>

      <!--
        Nope, we don't have a full URL, therefore we interpret this as a
        relative hyperlink to another document. We need to translate its
        name from "*.xml" to "*.html" (because this is how we convert the
        names) and the text included in this will be the title of the
        target document.
      -->
      <xsl:otherwise>
        <!--
          The "file" variable contains the part of the "href" before
          the "#" character. Yes, the "file" name.
        -->
        <xsl:variable name="file">
          <xsl:choose>
            <xsl:when test="contains($href,'#')">
              <xsl:value-of select="substring-before($href,'#')" />
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="$href" />
            </xsl:otherwise>
          </xsl:choose>
        </xsl:variable>

        <!--
          Like "file" the "anchor" variable contains the part of the "href"
          after the "#" character.
        -->
        <xsl:variable name="anchor">
          <xsl:if test="contains($href,'#')">
            <xsl:value-of select="'#'" />
            <xsl:value-of select="substring-after($href,'#')" />
          </xsl:if>
        </xsl:variable>

        <!--
          Good, now we check if "file" ends in ".xml", if so, we replace that
          with ".html", otherwise we keep its original value, then we add the
          anchor we gathered before. We call this "target".
        -->
        <xsl:variable name="target">
          <xsl:value-of select="$homedoc"/>
          <xsl:if test="string-length($file) > 0">
            <xsl:choose>
              <xsl:when test="substring($file,string-length($file)-3) = '.xml'">
                <xsl:value-of select="substring($file,1,string-length($file)-3)"/>
                <xsl:value-of select="'html'"/>
              </xsl:when>
              <xsl:otherwise>
                <xsl:value-of select="$file"/>
              </xsl:otherwise>
            </xsl:choose>
          </xsl:if>
          <xsl:value-of select="$anchor"/>
        </xsl:variable>
        
        <!--
          Now, we want to set the attribute to contain the "target" variable.
        -->
        <xsl:attribute name="{$attr}">
          <xsl:value-of select="$target"/>
        </xsl:attribute>

        <!--
          To finish we want to set the body of this element: if we have "text"
          the body of the element will be just that, otherwise, it will be
          the "target" value (the translated href) if there was no text,
          or the "title" of the target document if we actually translated
          something
        -->
        <xsl:if test="string-length($text) = 0">
          <xsl:choose>
            <xsl:when test="$target = $href">
              <xsl:value-of select="$file"/>
            </xsl:when>
            <xsl:otherwise>
              <xsl:value-of select="document($file)/document/properties/title"/>
            </xsl:otherwise>
          </xsl:choose>
        </xsl:if>
        <xsl:value-of select="$text"/>

      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>

</xsl:stylesheet>
