%%% File    : sowap_release.erl
%%% Author  : Johan Blom <johblo@dragon.cellpt.co.uk>
%%% Purpose : Release utils
%%% Created :  6 Jul 2001 by Johan Blom <johblo@dragon.cellpt.co.uk>

-module(sowap_release).
-author('tobbe@eddieware.org').
-modifiedby('jb@cellpt.com').

-vc('$Id: eddie_rootdir.erl,v 1.1.1.1 2000/10/27 22:20:15 dredd Exp $ ').
-export([start/1]).

-export([script/1, tar/1]).

%%% Function: Write the Erlang root dir to the file: root_dir.result
%%% Stolen from Eddie!
start([ResultFile]) when atom(ResultFile) ->
    case file:open(atom_to_list(ResultFile),[write,raw]) of
	{ok,Fd} ->
	    file:write(Fd,code:root_dir()),
	    file:sync(Fd),
	    file:close(Fd);
	_ ->
	    false
    end,
    halt().

%%% Utils to aid in creating scripts
%%% Stolen from Eddie!
script([RelFile, Emulator]) ->
    F = atom_to_list(RelFile),    
    script2(F,Emulator,"");
script([RelFile, Emulator, Prefix]) ->
    F = atom_to_list(RelFile),    
    Pre = atom_to_list(Prefix),
    script2(F,Emulator,Pre).

script2(F,Emulator,Pre) ->
    case catch systools:make_script(F, [{machine, Emulator},
				        {variables, [{"SOWAP_ROOT",Pre}]}]) of
	ok ->
	    halt();
	{'EXIT', Error} ->
	    io:format("Error = ~p~n", [Error]),
	    halt(1);
	E ->
            io:format("~p~n", [E]),
	    halt(1)
    end.

%% Module tests are supposed to have been made in make_script !
tar([RelFile, Emulator | ErtsDir]) ->
    F = atom_to_list(RelFile),
    Erts = include_erts(ErtsDir),
    case catch systools:make_tar(F, [{machine, Emulator},
				     no_module_tests |
				     Erts]) of
	ok ->
	    halt();
	{'EXIT', Error} ->
	    io:format("Error = ~p~n", [Error]),
	    halt(1);
	_ ->
	    halt(1)
    end.

include_erts([])      -> [];
include_erts(ErtsDir) -> [{erts, atom_to_list(ErtsDir)}].


		    
