-ifndef(LOGGING).
-define(LOGGING,true).

-define(TIMESTAMP, erlang:now()).


%%______________________________________________________________________
%% Debug/trace output
%% 

-define(debug(Format,Args,Func),
	wap_log:log(dbg, Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).
-define(trace(Format,Args,Func),
	wap_log:log(tra,Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).
-define(info(Format,Args,Func),
	wap_log:log(inf,Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).
-define(warning(Format,Args,Func),
	wap_log:log(wrn,Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).
-define(error(Format,Args,Func),
	wap_log:log(err,Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).
-define(fatal(Format,Args,Func),
	wap_log:log(fat,Format,Args,?MODULE,Func,?LINE,self(),?TIMESTAMP)).

%-define(debug(Format,Args,Func),
%	io:format("DEBUG:~p ~p:~p "++Format++"~n",
%		  [?TIMESTAMP,?MODULE,Func|Args])).
%% ?om_fm_debug(Format,Args,Func)).
%-define(trace(Format,Args,Func),
%	io:format("TRACE:~p ~p:~p "++Format++"~n",
%		  [?TIMESTAMP,?MODULE,Func|Args])).
%% ?om_fm_trace(Format,Args,Func)).
%-define(info(Format,Args,Func),
%	io:format("INFO:~p ~p:~p "++Format++"~n",
%		  [?TIMESTAMP,?MODULE,Func|Args])).
%% ?om_fm_info(Format,Args,Func)).
%-define(warning(Format,Args,Func),
%	io:format("WARNING:~p ~p:~p "++Format++"~n",
%		  [?TIMESTAMP,?MODULE,Func|Args])).
%% ?om_fm_warning(Format,Args,Func)).
%-define(error(Format,Args,Func),
%	io:format("ERROR:~p ~p:~p "++Format++"~n",
%	  [?TIMESTAMP,?MODULE,Func|Args])).
% ?om_fm_error(Format,Args,Func)).
%
-endif.
