%%%----------------------------------------------------------------------
%%% File    : wap_gateway.erl
%%% Author  : Johan Blom <johblo@dragon.cellpt.se>
%%% Purpose : WAP Gateway application
%%% Created : 29 Aug 2000 by Johan Blom <johblo@dragon.cellpt.se>
%%%----------------------------------------------------------------------

-module(wap_gateway).
-author('johblo@dragon.cellpt.se').
-behaviour(application).
-revision('$Revision: 1.2 $ ').
-rcsid('@(#) $Id: wap_gateway.erl,v 1.2 2001/07/10 12:53:28 johblo Exp $ ').
-modified('$Date: 2001/07/10 12:53:28 $ ').
-modified_by('$Author: johblo $ ').
-vsn("1").

%% WAP Gateway start and stop
-export([start/0,stop/0]).

%% Internal application callbacks
-export([start/2, stop/1]).

-define(START_OPTIONS,[]).

-include("utilslog.hrl").

start() ->
    application:start(sowaputils).

stop() ->
    application:stop(sowaputils).

%%%----------------------------------------------------------------------
%%% Callback functions from application
%%%----------------------------------------------------------------------

%%----------------------------------------------------------------------
%% Func: start/2
%% Returns: {ok, Pid}        |
%%          {ok, Pid, State} |
%%          {error, Reason}   
%%----------------------------------------------------------------------
start(Type,StartArgs) ->
    application:start(sowapstack),
    case wap_gateway_sup:start_link(StartArgs) of
	{ok,Pid} ->
	    Child={wap_gateway_man, {wap_gateway_man, start_link, []},
		   permanent, 2000, worker, [wap_gateway_man]},
	    case supervisor:start_child(Pid,Child) of
		{ok,_} ->
		    {ok,Pid};
		{error,Reason} ->
		    ?error("Can't start WAP Gateway man:~p~n",[Reason],start),
		    {error,cant_start_gateway}
	    end;
	{error,Reason} ->
	    ?error("Can't start WAP Gateway sup:~p~n",[Reason],start),
	    {error,cant_start_gateway}
    end.

%%----------------------------------------------------------------------
%% Func: stop/1
%% Returns: any 
%%----------------------------------------------------------------------
stop(State) ->
    application:stop(sowapstack),
    wap_gateway_sup:stop(),
    ?trace("WAP Gateway Application stopped",[],stop),
    ok.

%%%----------------------------------------------------------------------
%%% Internal functions
%%%----------------------------------------------------------------------
