%%% File    : wap_gateway_db.erl
%%% Author  : Johan Blom <johblo@dragon.cellpt.se>
%%% Purpose : WAP Gateway database
%%% Created : 26 Sep 2000 by Johan Blom <johblo@dragon.cellpt.se>

-module(wap_gateway_db).
-author('johblo@dragon.cellpt.se').
-behaviour(gen_server).
-revision('$Revision: 1.2 $ ').
-rcsid('@(#) $Id: wap_gateway_db.erl,v 1.2 2001/07/10 12:53:28 johblo Exp $ ').
-modified('$Date: 2001/07/10 12:53:28 $ ').
-modified_by('$Author: johblo $ ').
-vsn("1").

%% External exports
-export([start_link/0,find_appref/0]).

%% gen_server callbacks
-export([init/1, handle_call/3, handle_cast/2, handle_info/2,
	 terminate/2, code_change/3]).

-record(state,{app_db % (ets) Database with StackRef/ApplicationRef
	      }).

-include("utilslog.hrl").

-define(START_OPTIONS,[]).
-define(GDBCALL,             {global,?MODULE}).

find_appref() ->
    gen_server:call(?GDBCALL,find_appref).

%%%----------------------------------------------------------------------
%%% Maintenance
start_link() ->
    gen_server:start_link(?GDBCALL, ?MODULE, [], ?START_OPTIONS).


%%% FIXME! WARNING: Things are hardcoded here now, that shouldn't be!!
%%% This needs improvement!!
%%% - Doesn't work if this process is restarted (as the stacks are restarted)
init(Args) ->
    wap_stack_man:stop_stack(0), %% Assumes StackRef 0 
    wap_stack_man:stop_stack(1), %% Assumes StackRef 1 
    case application:get_env(sowaputils,stack_types) of
	{ok,Stacklist} ->
	    MyIP=get_my_ipaddr(),
	    Appdb=ets:new(app_db,[set, private]),
	    start_stacks(Stacklist,MyIP,Appdb),
	    ?trace("WSP Gateway db started ~p ok",[Stacklist],init),
	    {ok, #state{app_db=Appdb}};
	Error ->
	    ?error("No stack info, got ~p",[Error],init),
	    {stop,normal}
    end.

get_my_ipaddr() ->
    case net_adm:localhost() of
	{error,X2} ->
	    io:format("WARNING: Can't find DNS Hostname, got error:~p~n",
		      [X2]),
	    {error,X2};
	IP ->
	    inet:getaddr(IP,inet)
    end.

start_stacks([],_,_) ->
    ok;
start_stacks([Stack|Stacklist],MyIP,Appdb) ->
    {ok,StRef1}=wap_stack_man:start_stack(Stack),
    {ok,AppRef1}=wap_stack_man:app_reg(StRef1,
				       proxy,undefined,MyIP,any_any_ipv4),
    ets:insert(Appdb,{StRef1,[AppRef1]}),
    start_stacks(Stacklist,MyIP,Appdb).

terminate(Reason, State) ->
    ?trace("WSP Gateway db stopped:~p",[Reason],terminate).

%%----------------------------------------------------------------------
%% Func: handle_call/3
%% Returns: {reply, Reply, State}          |
%%          {reply, Reply, State, Timeout} |
%%          {noreply, State}               |
%%          {noreply, State, Timeout}      |
%%          {stop, Reason, Reply, State}   | (terminate/2 is called)
%%          {stop, Reason, State}            (terminate/2 is called)
%%----------------------------------------------------------------------
handle_call({lookup_stack,Sref},_,State) ->
    Ans=case ets:lookup(State#state.app_db,Sref) of
	    [{_,AppRefList}] ->
		AppRefList;
	    [] ->
		{error,stack_notfound}
	end,
    {reply,Ans,State};
handle_call(find_appref,_,State) ->
    Ans=filter_apprefs(ets:tab2list(State#state.app_db)),
    {reply,Ans,State};
handle_call({remove_stack,Sref},_,State) ->
    ets:delete(State#state.app_db,Sref),
    {reply,ok,State};
handle_call(print_stacks,_, State) ->
    L=case ets:tab2list(State#state.app_db) of
	  [] ->  "No active";
	  A ->   A
      end,
    io:format("Running WAP Stacks: ~p~n",[L]),
    {reply,ok,State}.

filter_apprefs([]) ->
    [];
filter_apprefs([{_,AppRefList}|L]) ->
    AppRefList++filter_apprefs(L).

%%----------------------------------------------------------------------
%% Func: handle_cast/2
%% Returns: {noreply, State}          |
%%          {noreply, State, Timeout} |
%%          {stop, Reason, State}            (terminate/2 is called)
%%----------------------------------------------------------------------
handle_cast(Msg, State) ->
    {noreply, State}.

%%----------------------------------------------------------------------
%% Func: handle_info/2
%% Returns: {noreply, State}          |
%%          {noreply, State, Timeout} |
%%          {stop, Reason, State}            (terminate/2 is called)
%%----------------------------------------------------------------------
handle_info(Info, State) ->
    {noreply, State}.


%%----------------------------------------------------------------------
%% Func: code_change/3
%% Purpose: Convert process state when code is changed
%% Returns: {ok, NewState}
%%----------------------------------------------------------------------
code_change(OldVsn, State, Extra) ->
    {ok, State}.

%%%----------------------------------------------------------------------
%%% Internal functions
%%%----------------------------------------------------------------------
