%%% File    : wap_gateway_sup.erl
%%% Author  : Johan Blom <johblo@dragon.cellpt.se>
%%% Purpose : Supervisor for the WAP Gateway  application
%%% Created : 29 Aug 2000 by Johan Blom <johblo@dragon.cellpt.se>

-module(wap_gateway_sup).
-author('johblo@dragon.cellpt.se').
-behaviour(supervisor).
-revision('$Revision: 1.2 $ ').
-rcsid('@(#) $Id: wap_gateway_sup.erl,v 1.2 2001/07/10 12:53:28 johblo Exp $ ').
-modified('$Date: 2001/07/10 12:53:28 $ ').
-modified_by('$Author: johblo $ ').
-vsn("1").

%% External exports
-export([start_link/1,stop/1]).

%% Internal supervisor callbacks
-export([init/1]).

-define(GSVNAME,?MODULE).
-define(GSVCALL,{local,?GSVNAME}).

-include("utilslog.hrl").

%%%----------------------------------------------------------------------
%%% External exports
%%%----------------------------------------------------------------------
start_link(StartArgs) ->
    supervisor:start_link(?GSVCALL,?GSVNAME, StartArgs).

stop(State) ->
    ?trace("Stopping supervisor ~p",[State],stop),
    ok.

%%%----------------------------------------------------------------------
%%% supervisor callbacks
%%%----------------------------------------------------------------------

%%----------------------------------------------------------------------
%% Func: init/1
%% Returns: {ok,  {SupFlags,  [ChildSpec]}} |
%%          ignore                          |
%%          {error, Reason}   
%%----------------------------------------------------------------------
init(Arg) ->
    Childs = [{wap_gateway_db, {wap_gateway_db, start_link, []},
	       permanent, 2000, worker, [wap_gateway_db]}],
    {ok, {{one_for_one,1,1}, Childs}}.

%%%----------------------------------------------------------------------
%%% Internal functions
%%%----------------------------------------------------------------------
