// KDat - a tar-based DAT archiver
// Copyright (C) 1998  Sean Vyain, svyain@mail.tds.net
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <unistd.h>
#include <stdlib.h>

#include <qfile.h>
#include <qdir.h>

#include <kapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>

#include "kdat.h"
#include "KDat.h"

static const char *description = 
	I18N_NOOP("tar-based DAT archiver for KDE");


int main( int argc, char** argv )
{
  KAboutData aboutData( "kdat", I18N_NOOP("KDat"), 
    KDAT_VERSION, description, KAboutData::License_GPL, 
    "(c) 1999-2000, Sean Vyain");
  KCmdLineArgs::init( argc, argv, &aboutData );
  aboutData.addAuthor( "Sean Vyain", 0, "svyain@mail.tds.net");
//  KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.
  KApplication app;
  
    // Test for the existance of $HOME/.kdat
    QString fn = QDir::homeDirPath();
    fn += "/.kdat";
    QFile file( fn );
    if ( !file.exists() ) {
        mkdir( QFile::encodeName(fn), 0700 );
    }

    app.setMainWidget( KDat::getInstance() );

    if ( app.isRestored() && KDat::canBeRestored( 1 ) ) {
        KDat::getInstance()->restore( 1 );
    } else {
        KDat::getInstance()->show();
    }

    return app.exec();
}
