//////////////////////////////////////////////////////////////////////////
// $Id: kpackage.h,v 1.27 2000/09/01 20:19:46 waba Exp $	
// File  : kpackage.h
// Author: Damyan Pepper
// Author: Toivo Pedaste
//
// This is the main widget for kpackage
// The whole widget is a DND drop zone where users can drop packagess to 
// be installed.
// The widget can be in one of two modes: management and installation.
//
// Management mode displays a tree list showing all the packages that are 
// currently installed on the system (each in their appropriate groups)
// and a display of the currently selected package's properties.
// 
// Installation mode displays the properties of the package to install
// and a set of options for installation
//
// The displays for each of these modes are contained within a widget.
// When the mode changes, the appropriate widget is show and the other
// hidden.
//
// KPACKAGE also holds the menu bar.  At current, the menu structure is as
// follows:kpackage
//
// File -> Quit
// Help -> About
//
// This will, of course, be expanded in future versions as more 
// functionality is added to the application.
//////////////////////////////////////////////////////////////////////////

#ifndef KPACKAGE_H
#define KPACKAGE_H

#include "../config.h"

// Standard Headers
#include <stdio.h>

// Qt Headers
#include <qdir.h>
#include <qwidget.h>
#include <qframe.h>
#include <qlabel.h>
#include <qfiledlg.h> 
#include <qgrpbox.h> 

// KDE headers
#include <kapp.h>
#include <kdebug.h>
#include <kconfig.h>
#include <kurl.h>
#include <kprogress.h>
#include <kmenubar.h>
#include <kmainwindow.h> 
#include <kfiledialog.h> 
#include <kaction.h>

class Search;
class FindF;
class Options;
class pkgInterface;
class managementWidget;
class KAccel;
class QDropEevnt;
class KRecentFilesAction;
class KAction;

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
class KPACKAGE : public QWidget
{
  Q_OBJECT;

  ///////////// METHODS ------------------------------------------------------
public:
  KPACKAGE(KConfig *_config, QWidget *parent=0);
  // Constructor

  ~KPACKAGE();
  // Destructor

    enum { OPEN_READWRITE 	= 1, 
	   OPEN_READONLY 	= 2, 
	   OPEN_INSERT 		= 4 };

  void setStatus(QString s);
  // this sets the status bar's string to s

  void setPercent(int x);
  // this set the status bar's progress to x

  QString getStatus();
  // this gets the current status string on the status bar

  void setMode(int newmode, pkgInterface *type, int refresh);
  // This sets the mode to newmode and updates the display accordingly.

  void installPackage(QString name, pkgInterface *type);
  // this installs a package

  pkgInterface *pkType(QString fname);
  // find type of package

  void openNetFile(const KURL & _url);
  // open a file given a URL

  QString fetchNetFile(const KURL & url);
  // fetch a file given a URL

  static QString getFileName(const KURL & url, QString &cacheName);
  // return file name, if not local file cachename is name for cache entry


protected:
  void resizeEvent(QResizeEvent *re);
  // This is called when the widget is resized

  void dropEvent(QDropEvent *);
  // This is called when a URL has been dropped in the drop zone

  void dragEnterEvent(QDragEnterEvent* e);

private:

  void setupModeWidgets();
  // This sets up the mode widgets (ie management/installation widgets)

  void destroyModeWidgets();
  // This deletes the mode widgets (ie management/installation widgets)

  void setupStatusBar();
  // This sets up the status bar

  void arrangeWidgets();
  // This arranges the widgets in the window (should be called after a
  // resize event)

  KFileDialog* getFileDialog(QString captiontext);

  ///////////// SLOTS --------------------------------------------------------
public slots:
    
  void modeFinished(int mode, pkgInterface *interface, int refresh);
  // This is called when the mode `mode' has finished.  KPACKAGE should
  // then change modes appropriately

  void fileOpen();
  // This is called when File->Open is selected from the menu

  void clearMarked();
  // clear package Marks

  void expandTree();
  void collapseTree();
  // expand and collapse file tree

  void fileOpenUrl();
  // menu item FIle->OpenUrl

  void find();
  // search for package

  void findf();
  // search for file in package

  void fileQuit();
  // This is called when File->Quit is selected from the menu

  void reload();
  // reload file package infomation

  void helpAbout();
  // This is called when Help->About is selected from the menu

  void helpHelp();
  // This is called when Help->Help is selected from the menu

  ///////////// SIGNALS ------------------------------------------------------

  ///////////// DATA ---------------------------------------------------------
public:

  enum { Management, Installation } ; 
  // Widget modes

  KConfig *config;
  // pointer to kconfig object

  managementWidget *management;
  // management widget

  KURL save_url;
  // save the URL entered

private:
  int mode;
  // Widget mode

  // Menu item identifiers

  QFrame *statusbar;	    
  // the status bar

  KProgress *processProgress;
  // Progress bar for showing progress

  QLabel *status;
  // The actual status

  KFileDialog *file_dialog;
  /// If we load a file from the net this is the corresponding URL

  Search *srchdialog;
  // find package dialog

  FindF *findialog;
  // find file dialog
};

//////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

class KPKG : public KMainWindow
{
  Q_OBJECT;

  enum { Tback = 1,
	 Tforward = 2,
	 Tfileopen = 3,
	 Tftout = 4,
	 Tftin = 5,
	 Tfind = 6,
	 Tfindf = 7,
	 Treload = 8
  };

public:

  KPKG(KConfig *_config);
  // Constructor

  ~KPKG();
  // Destructor

  void add_recent_file(QString newfile);
  // keep list of files accessed

  void writeSettings();
  // write config settings

  void saveProperties(KConfig *config);
  void readProperties(KConfig *config);
  // save and read restart sstate

  void disableMenu();
  void enableMenu();	
  // enable/deisable menu elements

  bool prop_restart;
  // indicates a restart from saved state

  QStringList urlList;
  // For multiple drops save list of URL's for processing

  Options *optiondialog;
  // Options dialog

  KConfig *config ;
  // Saved config information

  KAccel *keys;

  void disableNext();
  void enableNext();
  void disablePrevious();
  void enablePrevious();
  // Control next and previous commands

private:

  void setupMenu();
  // This sets up the menubar

  QStrList recent_files;

  KAction *pack_open;
  KAction *pack_find;
  KAction *pack_findf;
  KAction *kpack_reload;
  KAction *pack_prev;
  KAction *pack_next;
  KToggleAction *pack_toolbar;

  int  toolID, selectID;
  // refrences to  toolbar  and menu items

  bool hide_toolbar;
  // don't display toolbar

  KRecentFilesAction *recent;

public slots:

  void openRecent(const KURL& url);
  // opens file from list of recently opened ones

  void setOptions();
  // set options
  
  void setKeys();
  
  void saveSettings();
  // save config
  
  void toggleToolBar();
  // toggle existance of tool bar

  void configureToolBars();

  void clearPCache();
  // Clear package cache

  void clearDCache();
  // Clear directory cache

protected:
    void closeEvent ( QCloseEvent *e);
};

//////////////////////////////////////////////////////////////////////////////

extern KPKG *kpkg;
extern KPACKAGE *kpackage;

extern pkgInterface *kpinterface[];
extern const int kpinterfaceN;

void KpMsg(QString lab, QString msg, bool stop);
void KpMsgE(QString msg, bool stop = FALSE);
#endif



