//////////////////////////////////////////////////////////////
//      $Id: slackInterface.h,v 1.10 2000/08/05 19:45:51 bieker Exp $ 
//
// Author: Toivo Pedaste
//
//////////////////////////////////////////////////////////////

#ifndef SLACK_IFACE_H
#define SLACK_IFACE_H

#include "../config.h"

#include <qlist.h>
#include <kprocess.h>

#include "procbuf.h"
#include "pkgInterface.h"

class packageInfo;
class updateLoc;
class cacheObj;

class SLACK: public pkgInterface
{
  Q_OBJECT

public:
  SLACK();
  ~SLACK();
  
  bool isType(char *buf, const QString &fname);
  param *initinstallOptions();
  param *inituninstallOptions();
  packageInfo *getPackageInfo(char mode, const QString &name, const QString &version);
  QStringList *getFileList(packageInfo *p);

  QString FindFile(const QString &name);
  bool parseName(QString name, QString *n, QString *v);

  int install(int installFlags, QList<packageInfo> *plist);

public slots:
  void setLocation();
  void setAvail(LcacheObj *);

private:
  packageInfo* collectInfo(const char *inp, int insState);
   void listInstalledPackages(QList<packageInfo> *pki);
 
  int doUninstall(int installFlags, QString packs);
  int doInstall(int installFlags, QString packs);

  void listPackages(QList<packageInfo> *pki);
  void listPackList(QList<packageInfo> *pki, QString s,
		    cacheObj *cp, int insState);

  void initTranslate();

  void smerge(packageInfo *p);

  QDict<QString> *trl;
};

#endif



