/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include "fileparser.h"

#include <qfile.h>

FileParser::FileParser(const QString& fname) : _eof(true)
{
  if (!(_fhd = fopen(QFile::encodeName(fname), "r"))) perror("fopen");
  else
  {
    _filepos = ftell(_fhd);
    _eof = feof(_fhd);
  }
}


FileParser::~FileParser()
{
  if (_fhd) fclose(_fhd);
}


/*
 * Public methods
 *****************/

QString  FileParser::nextLine()
{
  char  buffer[256];
  
  if (_fhd)
  {
    _filepos = ftell(_fhd);
    
    if (!fgets(buffer, sizeof(buffer), _fhd)) _eof = true;
    else return QString(buffer).simplifyWhiteSpace();
  } 
  
  return QString("");
}


bool  FileParser::reset()
{
  if (_fhd)
  {
    _filepos = 0;
    _eof     = false;
   
    rewind(_fhd); 
    return true;
  }
  
  return false;
}


bool  FileParser::traceBack()
{
  if (!_filepos) return false;

  fseek(_fhd, _filepos, SEEK_SET);
  _filepos = 0;
    
  return true;
}
