/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <kapp.h>

#include "dmaport.h"
#include "resentry.h"


ResourceEntry::ResourceEntry(QListView *parent, Resource *res) : QListViewItem(parent),
								 _resource(res)
{
  fillIn();
}


/*
 * Public methods
 *****************/
 
void  ResourceEntry::setResource(Resource *res)
{
  _resource = res;
  
  fillIn();
  repaint();
}


/*
 * Private methods
 ******************/
 
void  ResourceEntry::fillIn()
{
  QString  resname = _resource->resourceUpperName();
  QString  resval, rngstr, numstr;
  uint     ioaddr;
  ulong    memaddr;
  ulong    range   = _resource->resourceRange();
  
  switch (_resource->resourceType())
  {
    case Resource::ResInterrupt  : resval.sprintf("%02i", _resource->resourceValue());
    			           break;
    case Resource::ResDMAPort    : resname = i18n("DMA ")+numstr.setNum(((DMAPort *) _resource)->bits() >> 4);
                                   resval.sprintf("%02i", _resource->resourceValue());
    			           break;
    case Resource::ResIOAddress  : ioaddr  = _resource->resourceValue();
 
                                   if (range == 1) rngstr = "????";
                                   else            rngstr.sprintf("%04x", ioaddr+range-1);
 
                                   resval.sprintf("%04x-%s", ioaddr, rngstr.utf8().data());
    			           break;
    case Resource::ResMemAddress : memaddr = _resource->resourceValue();

                                   if (range == 1) rngstr = "????????";
                                   else            rngstr.sprintf("%08x", memaddr+range-1);
    
                                   resval.sprintf("%08x-%s", memaddr, rngstr.utf8().data());
    default                      : break; // Do nothing
  }
  
  setText(0, resname+"  "); 
  setText(1, resval.upper()+"                "); 
}
