/*
 *  This file is part of the KDE System Control Tool,
 *  Copyright (C)1999 Thorsten Westheider <twesthei@physik.uni-bielefeld.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ****************************************************************************/

#include <qlayout.h>

#include <klocale.h>

#include "scsidevice.h"
#include "scsiinfobox.h"


SCSIInfoBox::SCSIInfoBox(Device *device, QWidget *parent, 
                         const char *name) : QWidget(parent, name)
{
  QString  targetstr, logdevstr, firmstr;
  bool     scsi;
  
  if ((scsi = (device->busType() == Device::BusSCSI)))
  {
    SCSIDevice  *scsidev = (SCSIDevice *) device;
    
    targetstr.setNum(scsidev->targetID());
    logdevstr.setNum(scsidev->logicalUnit());
    firmstr.setNum(scsidev->firmwareRevision());
  }

  QLabel  *targetlabel = new QLabel(i18n("Target ID:"),           this, "targetlabel");
  QLabel  *targetvalue = new QLabel(targetstr,                    this, "targetvalue");
  QLabel  *logdevlabel = new QLabel(i18n("Logical device unit:"), this, "logdevlabel");
  QLabel  *logdevvalue = new QLabel(logdevstr,                    this, "logdevvalue");
  QLabel  *firmlabel   = new QLabel(i18n("Firmware revision:"),   this, "firmlabel");
  QLabel  *firmvalue   = new QLabel(firmstr,                      this, "firmvalue");

  targetlabel->setEnabled(scsi);
  logdevlabel->setEnabled(scsi);
  firmlabel->setEnabled(scsi);

  QHBoxLayout  *toplayout  = new QHBoxLayout(this, -1, -1, "toplayout");
  QGridLayout  *gridlayout = new QGridLayout(toplayout, 3, 8);
  
  gridlayout->addColSpacing(1, 8);
  gridlayout->addColSpacing(3, 16);
  gridlayout->addColSpacing(5, 8);
  gridlayout->addColSpacing(7, 16);

  gridlayout->addRowSpacing(1, 4);
  
  gridlayout->addWidget(targetlabel, 0, 0);
  gridlayout->addWidget(targetvalue, 0, 2);
  gridlayout->addWidget(logdevlabel, 2, 0);
  gridlayout->addWidget(logdevvalue, 2, 2);
  gridlayout->addWidget(firmlabel,   0, 4);
  gridlayout->addWidget(firmvalue,   0, 6);
  
  //toplayout->addStretch(1);
  toplayout->activate();
}

