/***************************************************************************
                          ConfigWizard.cpp  -  description
                             -------------------
    begin                : Sun Oct 3 1999
    copyright            : (C) 1997-99 by Peter Putzer
    email                : putzer@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; version 2.                              *
 *                                                                         *
 ***************************************************************************/

#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qframe.h>
#include <qlayout.h>
#include <qwizard.h>
#include <qtooltip.h>

#include <klocale.h>
#include <kapp.h>
#include <kdebug.h>

#include "ksv_core.h"
#include "ConfigWizard.h"

#define MIN_SIZE(A) A->setMinimumSize(A->sizeHint())

ConfigWizard::ConfigWizard( QWidget* parent, const char* name, WFlags f)
  : KWizard (parent, name, true, f)
{

  setCaption (kapp->makeStdCaption("Configuration Wizard"));

  // content
  QButtonGroup* group = new QButtonGroup (i18n("Distribution"), this, "DistribGroup");
  QBoxLayout* top = new QVBoxLayout (group);

  QRadioButton* r = new QRadioButton ("&Red Hat", group);
  MIN_SIZE(r);
  QToolTip::add (r, i18n("Red Hat Linux"));
  top->addWidget(r, 0, AlignLeft|AlignTop);

  r = new QRadioButton ("&Debian", group);
  MIN_SIZE(r);
  QToolTip::add (r, i18n("Debian GNU/Linux"));
  top->addWidget(r, 0, AlignLeft|AlignTop);


  r = new QRadioButton ("&SuSE", group);
  MIN_SIZE(r);
  QToolTip::add (r, i18n("SuSE Linux - from Germany"));
  top->addWidget(r, 0, AlignLeft|AlignTop);

  r = new QRadioButton ("D&LD", group);
  MIN_SIZE(r);
  QToolTip::add (r, i18n("Deutsche Linux Distribution"));
  top->addWidget(r, 0, AlignLeft|AlignTop);

  r = new QRadioButton ("&Mandrake", group);
  MIN_SIZE(r);
  QToolTip::add (r, i18n("A new distribution based on Red Hat"));
  top->addWidget(r, 0, AlignLeft|AlignTop);

  top->activate();

  //  QWizardPage* p = new QWizardPage();
  //  p->w = group;
  //  p->title = i18n("Select your distribution");
  QWidget* p = new QWidget(this);

  addPage(p, i18n("Select your distribution"));

  setFixedSize(sizeHint());
  setFixedWidth(300);

  // various button-actions
  connect (finishButton(), SIGNAL(clicked()), this, SLOT(accept()));
  connect (cancelButton(), SIGNAL(clicked()), this, SLOT(reject()));
  connect (helpButton(), SIGNAL(clicked()), this, SLOT(slotHelp()));

  static_cast<QPushButton*>(finishButton())->setDefault(true);
}

ConfigWizard::~ConfigWizard()
{
  // nothing
}

void ConfigWizard::slotHelp() const
{
  kdDebug(3000) << "Help not implemented." << endl;
  // FIXME
}

#include "ConfigWizard.moc"
