#ifndef EDITLIMIT_H
#define EDITLIMIT_H
#include "ftpaccess.h"
#include "InputFileCtl.h"
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qspinbox.h>	// I know I could use a KNumericSpinBox instead of a QSpinBox - but as of QT 1.40/KDE 1.0, a QSpinBox looks better...

class EditLimit : public QWidget {
	Q_OBJECT
public:
	EditLimit(ftplimit *limit=0, ftpclass *fcls=0, QWidget *parent=0, char * wname=0);
	~EditLimit();
public slots:
	void okButtonPressed();
	void cancelButtonPressed();
	void anyPressed();
	void notAnyPressed();
	void noLimitPressed();
	void limitPressed();
	void selectFilePressed();
signals:
	void EditLimitOk(ftplimit *, ftpclass *);
private:
	QRadioButton *	any;
	QRadioButton *	notAny;
	QCheckBox *	mo;
	QCheckBox *	tu;
	QCheckBox *	we;
	QCheckBox *	th;
	QCheckBox *	fr;
	QCheckBox *	sa;
	QCheckBox *	su;
	QLineEdit *	hrs;
	QSpinBox *	users;
	QRadioButton *	limitYes;
	QRadioButton *	limitNo;
	QPushButton *	ok;
	QPushButton *	cancel;
	ftplimit *	current;
	ftpclass *	fclass;
	InputFileCtl *	msgFile;
};
#endif
