/* This file is part of the KDE project
   Copyright (C) 1998, 1999 Torben Weis <weis@kde.org>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef __desktop_h__
#define __desktop_h__

#include "KDesktopIface.h"

#include <qstringlist.h>
#include <konq_fileitem.h>
#include <konq_iconviewwidget.h>
#include <qiconview.h>

#include <kurl.h>

class KonqDirLister;
class KonqSettings;
class QCloseEvent;
class QDropEvent;
class QPopupMenu;
class KGlobalAccel;
class KAccel;
class KWinModule;
class KDesktopFile;
class KBackgroundManager;
class QTimer;

#include <kaction.h>

class KDesktop : public KonqIconViewWidget, virtual public KDesktopIface
{
  Q_OBJECT
public:

  KDesktop(bool x_root_hack, bool auto_start, bool wait_for_kded );
  ~KDesktop();


  /**
   * Re-arrange the desktop icons
   * @param bAsk if true a confirmation is asked first
   */
  virtual void rearrangeIcons( bool bAsk );

  /**
   * Re-arrange the desktop icons without confirmation.
   */
  virtual void rearrangeIcons();

  /**
   * Lineup the desktop icons.
   */
  virtual void lineupIcons();
  /**
   * Select icons in the rectangle given
   */
  virtual void selectIconsInRect( int /*x*/, int /*y*/, int /*dx*/, int /*dy*/ )
   {/* selectByRubber( QRect(x, y, dx, dy) ); */ }
  /**
   * Select all icons
   */
  virtual void selectAll() { QIconView::selectAll( true ); }
  /**
   * Unselect all icons
   */
  virtual void unselectAll()  { QIconView::selectAll( false ); }
  /**
   * @return the urls of selected icons
   */
  virtual QStringList selectedURLs();
  /**
   * Re-read KDesktop's configuration
   */
  virtual void configure();
  /**
   * Display the "Execute Command" dialog (min-cli)
   */
  virtual void popupExecuteCommand();
  /**
   * Called by kcmlocale
   */
  virtual void languageChanged( const QString & lang );

  virtual void refreshIcons();

  virtual void logout();

  virtual DCOPRef background() { return DCOPRef( "kdesktop", "KBackgroundIface" ); }
  virtual DCOPRef screenSaver() { return DCOPRef( "kdesktop", "KScreensaverIface" ); }

  KWinModule* kwinModule() const { return m_pKwinmodule; }

  KActionCollection *actionCollection() { return &m_actionCollection; }

protected slots:

  void workAreaChanged();

  /**
   * Background is ready.
   */
  void backgroundInitDone();

  /**
   * Activate the desktop.
   */
  void slotStart();

  /**
   * Reconfigures
   */
  void slotConfigure();


  /**
   * Show minicli,. the KDE command line interface
   */
  void slotExecuteCommand();

  /**
   * Show taskmanger (calls KSysGuard with --showprocesses option)
   */
  void slotShowTaskManager();

  /**
   * Connected to KSycoca
   */
  virtual void slotDatabaseChanged();

  // slots connected to the icon view
  void slotReturnPressed( QIconViewItem *item );
  void slotMouseButtonPressed(int _button, QIconViewItem* _item, const QPoint& _global);
  void slotMouseButtonClickedKDesktop(int _button, QIconViewItem* _item, const QPoint& _global);
  void slotEnableAction( const char * name, bool enabled );
  void slotSaveDropPosition( QDropEvent *ev, const QValueList<QIconDragItem> & );

  void slotItemRenamed(QIconViewItem*);

  // slots connected to the directory lister
  void slotClear();
  void slotStarted();
  void slotCompleted();
  void slotNewItems( const KFileItemList& );
  void slotDeleteItem( KFileItem * );
  void slotRefreshItems( const KFileItemList& );

  // slots connected to the popupmenu (actions)
  void slotCut();
  void slotCopy();
  void slotTrash();
  void slotDelete();
  void slotShred();

  void slotShutdown();
  void slotSettingsChanged(int);
  void slotClipboardDataChanged();

public slots: // for krootwm

  void slotPaste();

private slots:
  void updateWorkArea();

protected:
  virtual void initConfig();
  KURL desktopURL();
  virtual void popupMenu( const QPoint &_global, KFileItemList _items );
  virtual void showEvent( QShowEvent *e );
  virtual void closeEvent( QCloseEvent * );
  virtual void contentsDropEvent(QDropEvent * e);
  virtual void viewportWheelEvent( QWheelEvent * );
  void mousePressEvent( QMouseEvent *e );
  virtual void contentsMousePressEvent( QMouseEvent *e );

  uint m_bNeedRepaint:1;
  uint m_bNeedSave:1;

  /** true if even one icon has an icon-position entry in the .directory */
  uint m_hasExistingPos:1;

  /**
   * Set to true while the constructor is running.
   * @ref #initConfig needs to know about that.
   */
  uint m_bInit:1;

  /** Show dot files ? */
  uint m_bShowDot:1;

  /** Execute files from autoexec folder? */
  uint m_bAutoStart:1;

  /** Wait for kded to finish building database? */
  uint m_bWaitForKded:1;

  /** Vertical or Horizontal align of icons on desktop */
  uint m_bVertAlign:1;

  QIconView::Arrangement m_tAlign;

  /** Settings - see libkonq/konqsettings.* */
  KonqSettings* m_pSettings;

  /** The directory lister for this URL */
  KonqDirLister* m_dirLister;

  KGlobalAccel *keys;
  KAccel *m_accel;

  KActionCollection m_actionCollection;

  KWinModule* m_pKwinmodule;

  KBackgroundManager* bgMgr;

  /** The desktop's .directory, used for storing icon positions */
  KDesktopFile *m_dotDirectory;

  /** Last added icon - used when renaming a file */
  KFileIVI * m_lastIcon;
  QTimer *updateWorkAreaTimer;

  QString m_language;
};

#endif
