/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qdir.h>

#include <klocale.h>
#include <kglobal.h>
#include <kglobalsettings.h>
#include <kdesktopfile.h>
#include <kstddirs.h>
#include <kiconloader.h>
#include <kapp.h>
#include <kurl.h>
#include <krun.h>

#include "browser_mnu.h"
#include "quickbrowser_mnu.h"
#include "quickbrowser_mnu.moc"

PanelQuickBrowser::PanelQuickBrowser(QWidget *parent, const char *name)
  : PanelMenu("", parent, name)
{}

void PanelQuickBrowser::initialize()
{
    if(init) return;
    init = true;
    
    QDir dir;
    dir.setSorting(QDir::DirsFirst| QDir::Name | QDir::IgnoreCase);
    dir.setFilter(QDir::Files);
    const QFileInfoList *list = dir.entryInfoList();

    int count = KGlobal::dirs()->findDirs("data", "quickbrowser").count();
    if(count){
	dir.setPath(KGlobal::dirs()->findDirs("data", "quickbrowser")
		    [count > 1 ? 1 : 0]);
	list = dir.entryInfoList();
	if(list){
	    QFileInfoListIterator it(*list);
	    parseBrowserApplnks(it);
	}
	if(count > 1){
	    dir.setPath(KGlobal::dirs()->findDirs("data", "quickbrowser")[0]);
	    if(dir.exists()){
		list = dir.entryInfoList();
		if(list){
		    QFileInfoListIterator it(*list);
		    parseBrowserApplnks(it);
		}
	    }
	}
    }
    adjustSize();
  
}

void PanelQuickBrowser::parseBrowserApplnks(QFileInfoListIterator &it)
{
    bool flag = false;
    QFileInfo *fi;
    for(; (fi = it.current()) != NULL; ++it)
	{
	    if(!KDesktopFile::isDesktopFile(fi->absFilePath())) continue;
	    
	    KDesktopFile dFile(fi->absFilePath());
	    dFile.setDollarExpansion(true); // need to expand $HOME and the like.
      
	    if(!flag){
		fileList.append("");
		flag = true;
	    }

	    // Double &'s so they aren't converted to accelerators.
	    QString name = dFile.readName();
	    name.replace(QRegExp("&"), "&&");
	    
	    if (dFile.hasDeviceType() || dFile.hasLinkType()) {
		PanelBrowserMenu *mnu =
		    new PanelBrowserMenu(KURL(dFile.readURL()).path(),
					 true, false, this,
					 0L, QDir::Dirs|QDir::Files);
		insertItem(SmallIconSet(dFile.readIcon()), name, mnu);
		fileList.append("");
	    } else{
		insertItem(SmallIconSet(dFile.readIcon()), name);
		fileList.append(fi->absFilePath());
	    }
	    
	}
}

void PanelQuickBrowser::slotExec(int id)
{
  kapp->propagateSessionManager();
  if(!fileList[id].isEmpty() && id)
    new KRun(fileList[id]); // will delete itself
}
