/**************************************************************************

    main.cpp  - The main function for KPager
    Copyright (C) 1998-2000  Antonio Larrosa Jimenez

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Send comments and bug fixes to larrosa@kde.org

***************************************************************************/

#include <kuniqueapp.h>
#include <klocale.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <qcolor.h>
#include <kdebug.h>

#include "kpager.h"

int main(int argc, char **argv)
{
    KAboutData *aboutdata = new KAboutData("kpager", "KPager", "1.5",
					   "Desktop Overview", KAboutData::License_GPL,
					   "(C) 1998,99,2000, Antonio Larrosa Jimenez","",
					   "http://www.arrakis.es/~rlarrosa/kmid.html");

    aboutdata->addAuthor("Antonio Larrosa Jimenez",
			 "Original Developer/Mantainer","larrosa@kde.org",
			 "http://www.arrakis.es/~rlarrosa/index.html");
    aboutdata->addAuthor("Matthias Elter",
			 "Developer","elter@kde.org", "");
    aboutdata->addAuthor("Matthias Ettrich",
			 "Developer","ettrich@kde.org", "");

    KCmdLineArgs::init(argc, argv, aboutdata);
    
    if (!KUniqueApplication::start()) {
	kdError() << "kpager is already running!" << endl;
	return 0;
    }

    KUniqueApplication *app = new KUniqueApplication;

    KPager *kpager=new KPager(0,"KPager");
    app->setMainWidget(kpager);
    kpager->show();

    int ret = app->exec();

    delete app;
    return ret;
};

