// $Id: ksplash.cpp,v 1.17 2000/10/05 22:02:58 ettrich Exp $

#include <stdlib.h>
#include <unistd.h>

#include <qpixmap.h>
#include <qtimer.h>
#include <qapplication.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qpainter.h>

#include <ksplash.h>
#include <kapp.h>
#include <dcopclient.h>
#include <kstddirs.h>
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <kprogress.h>
#include <kwin.h>

#include "ksplash.h"
#include "ksplash.moc"

static const char *version = "0.2";
static const char *description = I18N_NOOP( "The KDE Splash screen." );

KSplash::KSplash( const char* name )
    : QVBox( 0, name, WStyle_Customize | WStyle_StaysOnTop |
	     WStyle_NoBorderEx ), DCOPObject( name )
{
    KWin::setState( winId(), NET::StaysOnTop | NET::SkipTaskbar );
    setFrameStyle( QFrame::NoFrame );

    bar_active_pm = new QPixmap( locate("data", "ksplash/pics/splash_active_bar.png") );
    bar_inactive_pm = new QPixmap( locate("data", "ksplash/pics/splash_inactive_bar.png") );

    top_label = new QLabel( this );
    top_label->installEventFilter( this );
    top_label->setPixmap(QPixmap(locate("data", "ksplash/pics/splash_top.png")));

    bar_label = new QLabel( this );
    bar_label->setPixmap(*bar_inactive_pm);

    bottom_label = new QLabel( this );
    bottom_label->installEventFilter( this );
    bottom_label->setPalette(QPalette(black));
    bottom_label->setPixmap(QPixmap(locate("data", "ksplash/pics/splash_bottom.png")));

    status_label = new QLabel(bottom_label);
    status_label->installEventFilter( this );
    status_label->setPalette(QPalette(black));

    progress = new KProgress(status_label);
    progress->installEventFilter( this );
    progress->hide();

    state = 0;
    updateState();
    bottom_label->setFixedHeight(status_label->sizeHint().height()+4);

    QSize sh = sizeHint();

    move((QApplication::desktop()->width()- sh.width())/2,
	 (QApplication::desktop()->height()- sh.height())/2);

    setFixedSize(sh);

    QTimer::singleShot(500, this, SLOT( tryDcop() ) );
    
    close_timer = new QTimer( this );
    connect( close_timer, SIGNAL( timeout() ), this, SLOT( close() ) );
    close_timer->start( 10000, TRUE );
}

void KSplash::upAndRunning( QString s )
{
    bool update = true;
    if ( close_timer->isActive() )
	close_timer->start( 10000, TRUE );

    if ( s == "dcop" )
	{
	    if (state > 1) return;
	    else state = 1;
	}
    else if ( s == "kded" )
	{
	    if (state > 2) return;
	    else state = 2;
	}
    else if ( s == "kdesktop" )
	{
	    if (state > 3) return;
	    else state = 3;
	}
    else if ( s == "kicker" )
	{
	    if (state > 4) return;
	    else state = 4;
	}
    else if ( s == "kcminit" )
	{
	    if (state > 5) return;
	    else state = 5;
	}
    else if ( s == "start session" || s == "restore session" )
	{
	    if (state > 6) return;
	    else state = 6;
	    progress->show();
	}
    else if ( s == "session ready" )
	{
	    if (state > 7) return;
	    else state = 7;
	    close_timer->stop();
	    QTimer::singleShot(1000, this, SLOT( close() ) );
	}
    else
	update = false;

    if(update)
	updateState();
}

void KSplash::setMaxProgress(int m)
{
    progress->setRange(0, m );
}

void KSplash::setProgress(int p)
{
    progress->setValue( progress->maxValue() - p );
}

void KSplash::tryDcop()
{
    disconnect( kapp->dcopClient(), SIGNAL( attachFailed(const QString&) ),
		kapp, SLOT( dcopFailure(const QString&) ) );

    if ( kapp->dcopClient()->isAttached() )
	return;

    if ( kapp->dcopClient()->attach() ) {
	upAndRunning( "dcop" );
	kapp->dcopClient()->registerAs( "ksplash", false );
	kapp->dcopClient()->setDefaultObject( name() );
    }
    else {
	QTimer::singleShot(500, this, SLOT( tryDcop() ) );
    }
}

int main(int argc, char* argv[])
{
    if (fork())
	exit(0);

    KAboutData aboutData( "ksplash", I18N_NOOP("The KDE Splash Screen"),
			  version, description, KAboutData::License_BSD,
			  "(C) 2000, The KDE Developers");
    aboutData.addAuthor("Matthias Ettrich",0, "ettrich@kde.org");
    aboutData.addAuthor("Matthias Elter",0, "elter@kde.org");

    KCmdLineArgs::init(argc, argv, &aboutData);

    KApplication a;

    KSplash ksplash( "ksplash" );
    ksplash.show();

    a.setTopWidget( &ksplash );
    a.setMainWidget( &ksplash );
    return a.exec();
}

bool KSplash::eventFilter( QObject *, QEvent * e )
{
    if ( e->type() == QEvent::MouseButtonRelease ) {
	if ( geometry().contains( ( (QMouseEvent*)e)->globalPos() ) ) {
	    close();
	    return TRUE;
	}
    }
    return FALSE;
}

void KSplash::resizeEvent(QResizeEvent*)
{
    status_label->resize(bottom_label->width() - 7, bottom_label->height() - 4);
    status_label->move(5, 0);
    progress->resize(120, status_label->height());
    progress->move(status_label->width() - progress->width() - 4, 0);
}

void KSplash::updateState()
{
    QString text;
    switch(state) {
    case 0:
	text = i18n("Setting up interprocess communication.");
	break;
    case 1:
	text = i18n("Initializing system services.");
	break;
    case 2:
	text = i18n("Loading the desktop.");
	break;
    case 3:
	text = i18n("Loading the panel.");
	break;
    case 4:
	text = i18n("Initializing peripherals.");
	break;
    case 5:
	text = i18n("Restoring session...");
	break;
    default:
    case 6:
	text = i18n("KDE is up and running.");
	break;
    }
    status_label->setText(text);

    int offset = state * 68;
    QPixmap pm(*bar_active_pm);
    QPainter p(&pm);

    p.drawPixmap(offset, 0, *bar_inactive_pm, offset, 0);

    bar_label->setPixmap(pm);
}
