#!/bin/sh
# /etc/init.d/kdm: start or stop the X display manager
# Script stolen from the xdm package
set -e

PATH=/bin:/usr/bin:/sbin:/usr/sbin
DAEMON=/usr/bin/kdm
PIDFILE=/var/run/kdm.pid
UPGRADEFILE=/var/run/kdm.upgrade

test -x $DAEMON || exit 0

stillrunning () {
  if [ "$DAEMON" = "$(cat /proc/$DAEMONPID/cmdline 2> /dev/null)" ]; then
    true
  else
    # if the daemon does not remove its own pidfile, we will
    rm -f $PIDFILE $UPGRADEFILE
    false
  fi;
}

case "$1" in
  start)
    echo -n "Starting K display manager: kdm"
    start-stop-daemon --start --quiet --pidfile $PIDFILE --exec $DAEMON || echo -n " already running"
    echo "."
  ;;

  restart)
    /etc/init.d/kdm stop
    if [ -f $PIDFILE ]; then
      if stillrunning; then
        exit 1
      fi
    fi
    /etc/init.d/kdm start
  ;;

  reload)
    echo -n "Reloading K display manager configuration..."
    if start-stop-daemon --stop --signal 1 --quiet --pidfile $PIDFILE --exec $DAEMON; then
      echo "done."
    else
      echo "kdm not running."
    fi
  ;;

  force-reload)
    /etc/init.d/kdm reload
  ;;

  stop)
    echo -n "Stopping K display manager: kdm"
    if [ ! -f $PIDFILE ]; then
      echo " not running (no $PIDFILE)."
      exit 0
    else
      DAEMONPID=$(cat $PIDFILE | tr -d '[:blank:]')
      KILLCOUNT=1
      if [ ! -e $UPGRADEFILE ]; then
        start-stop-daemon --stop --quiet --pidfile $PIDFILE --exec $DAEMON || echo -n " not running"
      fi
      while [ $KILLCOUNT -le 5 ]; do
        if stillrunning; then
          kill $DAEMONPID
        else
          break
        fi
        sleep 1
        KILLCOUNT=$(expr $KILLCOUNT + 1)
      done
      if stillrunning; then
        echo -n " not responding to TERM signal (pid $DAEMONPID)"
      else
        if [ -e $UPGRADEFILE ]; then
          rm $UPGRADEFILE
        fi
      fi
    fi
    echo "."
  ;;

  *)
    echo "Usage: /etc/init.d/kdm {start|stop|restart|reload|force-reload}"
    exit 1
    ;;
esac

exit 0
