/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __taskbar_h__
#define __taskbar_h__

#include <qpushbutton.h>
#include <qtimer.h>
#include <qlist.h>
//#include <qintdict.h>
#include <qpixmap.h>
#include <qvaluelist.h>

#include <dcopobject.h>
#include <kwin.h>
#include <kpanelapplet.h>

#include "AppStarting.h"

enum Position { pLeft = 0, pRight, pTop, pBottom };
class TaskbarApplet;
class QGridLayout;

class AppStartButton : public QPushButton
{
    Q_OBJECT
public:
    AppStartButton(const QString &text, const QString &icon, pid_t pid, const QString & bin, bool compliant, QWidget * parent);
    QSizePolicy sizePolicy() const;
    QSize sizeHint() const;
    bool netCompliant() const { return compliant_; }
    QString bin() const { return bin_; }
    pid_t pid() const { return pid_; }
signals:
    void killMe(pid_t);
protected slots:
    void animTimerFired();
protected:
    void timerEvent(QTimerEvent *);
    void drawButton( QPainter *p );
    void mousePressEvent( QMouseEvent *e );
private:
    QPixmap pixmap;
    QList<QPixmap> anim;
    int frame;
    QTimer animTimer;
    pid_t pid_;
    QString bin_;
    bool compliant_;
};


class TaskButton: public QPushButton
{
    Q_OBJECT
public:
    TaskButton( WId w, TaskbarApplet * parent, const char *name = 0 );
    ~TaskButton();

    WId window() const { return win; }
    void setActiveButton();
    void refresh();
    void refreshIcon();
    bool onCurrentDesktop() const;
    QSizePolicy sizePolicy() const;
    QSize sizeHint() const;
    static void noActiveButton();

    void publishIconGeometry( const QPoint& );

    bool hasTransient( WId w ) const { return transients.contains( w ); }
    void addTransient( WId w ) { transients.append( w ); }
    void removeTransient( WId w ) { transients.remove( w ); }
    
    bool staysOnTop() const;

protected:
    enum WindowOperation {
        MaximizeOp = 100,
        IconifyOp,
        CloseOp
    };
    void drawButton(QPainter *p);
    void mousePressEvent( QMouseEvent *e );

private slots:
    void toggled();
    void clientPopupAboutToShow();
    void desktopPopupAboutToShow();

    void clientPopupActivated(int);
    void sendToDesktop(int);

private:
    static TaskButton* activeButton;
    WId win;
    QPixmap pixmap;
    KWin::Info info;

    QPopupMenu *popup;
    QPopupMenu *desk_popup;
    QValueList<WId> transients;
};

class TaskbarApplet : public KPanelApplet, virtual public AppStarting
{
    Q_OBJECT
public:
    TaskbarApplet(const QString& configFile, Type t = Normal, int actions = 0,
                  QWidget *parent = 0, const char *name = 0);
    ~TaskbarApplet();

    int widthForHeight(int h) const;
    int heightForWidth(int w) const;

    void resetLayout();

    void clientStarted(QString, QString, pid_t, QString, bool);
    void clientMapped(pid_t);
    void clientDied(pid_t);

    void setPosition(Position p);
    void init();

    void preferences();

protected slots:
    void killAppStartButton(pid_t);
    void windowAdded(WId);
    void windowRemoved(WId);
    void activeWindowChanged(WId);
    void windowChanged(WId, unsigned int);

    void currentDesktopChanged(int);

protected:
    void resizeEvent(QResizeEvent*);
    void reposition();

    void mousePressEvent( QMouseEvent* );
    void mouseReleaseEvent( QMouseEvent* );
    void mouseDoubleClickEvent( QMouseEvent* );
    void mouseMoveEvent( QMouseEvent* );

    bool x11Event(XEvent*);

private slots:
    void publishIconGeometries();

private:
    QMap<pid_t, AppStartButton *> appsStarting;
    QList<TaskButton> buttons;
    int taskbar_size;
    friend TaskButton; // for findButton
    TaskButton* findButton(WId w);

    Position pos;

    bool show_all;
    int visible_rows;
    void propagateMouseEvent( QMouseEvent*);

    QWidget     *_activeWidget; // Used in x11Event
    QGridLayout *_layout;
    QTimer        publishTimer;
};

#endif
