/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qlayout.h>

#include <kdebug.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kpanelapplet.h>

#include "global.h"
#include "panel.h"
#include "appletop_mnu.h"
#include "panelbutton.h"

#include "container_button.h"
#include "container_button.moc"

ButtonContainer::ButtonContainer(QWidget* parent)
  : BaseContainer(parent)
  , _button(0)
  , _layout(0)
  , _oldpos(0,0){}

void ButtonContainer::configure()
{
  if(_button)
    _button->configure();
}

void  ButtonContainer::saveConfiguration(const QString& group)
{
  if(_button) _button->saveConfiguration(group);
}

void ButtonContainer::slotSetPopupDirection(Direction d)
{
  BaseContainer::slotSetPopupDirection(d);

  if(_button)
    _button->slotSetPopupDirection(d);
}

void ButtonContainer::slotSetOrientation(Orientation o)
{
  BaseContainer::slotSetOrientation(o);

  if(_button)
    _button->slotSetOrientation(o);
}

void ButtonContainer::embedButton(PanelButton* b)
{
  if (!b) return;

  delete _layout;
  _layout = new QVBoxLayout(this);
  _button = b;

  _button->installEventFilter(this);
  _layout->add(_button);
  connect(_button, SIGNAL(requestSave()), SIGNAL(requestSave()));
}

bool ButtonContainer::eventFilter (QObject *, QEvent *e)
{
  switch (e->type())
    {
    case QEvent::MouseButtonPress:
      {
	    QMouseEvent* ev = (QMouseEvent*) e;
	    if ( ev->button() == RightButton )
          {
            if (!_opMnu)
              _opMnu = new PanelAppletOpMenu(_actions);

            switch(_opMnu->exec(getPopupPosition(_opMnu, ev->pos())))
              {
              case PanelAppletOpMenu::Move:
                _moveOffset = QPoint(width()/2, height()/2);
                emit moveme(this);
                break;
              case PanelAppletOpMenu::Remove:
				emit removeme(this);
                break;
			  case PanelAppletOpMenu::Help:
				help();
				break;
			  case PanelAppletOpMenu::About:
				about();
				break;
              case PanelAppletOpMenu::Preferences:
                if (_button)
                  _button->properties();
                break;
              default:
                break;
              }
            return true;
          }
        //else if ( ev->button() == LeftButton )
        //  {
        //    _oldpos = ev->pos();
        //    return false;
        //  }
		else if ( ev->button() == MidButton )
          {
            if (_button)
	      _button->setDown(true);
	    _moveOffset = ev->pos();
            emit moveme(this);
            return true;
          }
        return false;
      }
	  /*
    case QEvent::MouseMove:
      {
        QMouseEvent* ev = (QMouseEvent*) e;
        if ((ev->state() & LeftButton) == LeftButton)
          {
            QPoint p (ev->pos() - _oldpos);

            if (p.manhattanLength() > KGlobalSettings::dndEventDelay())
              {
                _moveOffset = ev->pos();
                emit moveme(this);
              }
          return true;
          }
        return false;
      }
	  */
    default:
      return false;
    }
}

void ButtonContainer::completeMoveOperation()
{
  if(_button)
    _button->setDown(false);
}

// KMenuButton container
KMenuButtonContainer::KMenuButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
  PanelKButton *b = new PanelKButton(this);
  _actions = KPanelApplet::Preferences;
  embedButton(b);
}

// DesktopButton container
DesktopButtonContainer::DesktopButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
  PanelDesktopButton *b = new PanelDesktopButton(this);
  embedButton(b);
}

// URLButton container
URLButtonContainer::URLButtonContainer(QWidget* parent, const QString &url )
  : ButtonContainer(parent)
{
  PanelURLButton *b = new PanelURLButton(url, this);
  _actions = KPanelApplet::Preferences;
  embedButton(b);
}

URLButtonContainer::URLButtonContainer(const QString& configGroup, QWidget* parent)
  : ButtonContainer(parent)
{
  KConfig *config = KGlobal::config();
  config->setGroup(configGroup);
  QString url = config->readEntry("URL");

  PanelURLButton *b = new PanelURLButton(url, this);
  _actions = KPanelApplet::Preferences;
  embedButton(b);
}

// BrowserButton container
BrowserButtonContainer::BrowserButtonContainer(QWidget* parent, const QString &startDir)
  : ButtonContainer(parent)
{
  PanelBrowserButton *b = new PanelBrowserButton(startDir, this);
  embedButton(b);
}

BrowserButtonContainer::BrowserButtonContainer(const QString& configGroup, QWidget* parent)
  : ButtonContainer(parent)
{
  KConfig *config = KGlobal::config();
  config->setGroup(configGroup);
  QString startDir = config->readEntry("Path");

  PanelBrowserButton *b = new PanelBrowserButton(startDir, this);
  embedButton(b);
}

// WindowListButton container
WindowListButtonContainer::WindowListButtonContainer(QWidget* parent)
  : ButtonContainer(parent)
{
  PanelWindowListButton *b = new PanelWindowListButton(this);
  embedButton(b);
}


// ExeButton container
ExeButtonContainer::ExeButtonContainer(QWidget *parent, const QString &filePath, const QString &icon,
                                       const QString &cmdLine, bool inTerm)
  : ButtonContainer(parent)
{
  PanelExeButton *b = new PanelExeButton(filePath, icon, cmdLine, inTerm, this);
  _actions = KPanelApplet::Preferences;
  embedButton(b);
}

ExeButtonContainer::ExeButtonContainer(const QString& configGroup, QWidget *parent)
  : ButtonContainer(parent)
{
  KConfig *config = KGlobal::config();
  config->setGroup(configGroup);
  QString filePath = config->readEntry("Path");
  QString icon = config->readEntry("Icon");
  QString cmdLine = config->readEntry("CommandLine");
  bool inTerm = config->readBoolEntry("RunInTerminal");

  PanelExeButton *b = new PanelExeButton(filePath, icon, cmdLine, inTerm, this);
  _actions = KPanelApplet::Preferences;
  embedButton(b);
}
