/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __containerarea_h__
#define __containerarea_h__

#include <qlist.h>

#include <dcopobject.h>

#include "global.h"
#include "panner.h"
#include "container_base.h"
#include "appletinfo.h"

class ExternalAppletContainer;

class ContainerArea : public Panner, DCOPObject
{
    Q_OBJECT
    K_DCOP

public:
    ContainerArea( Orientation orientation, QWidget* parent, const char* name = 0);
    ~ContainerArea();

k_dcop:
    int position();
    int orientation();
    int popupDirection();
   void addApplet( const QString& desktopFile );

public:

    void addKMenuButton();
    void addDesktopButton();
    void addWindowListButton();
    void addURLButton(const QString &url);
    void addBrowserButton(const QString &startDir);
    void addExeButton(const QString &filePath, const QString &icon,
		      const QString &cmdLine, bool inTerm);

    void addAppletContainer(const QString &desktopFile, bool internal);

    void configure();

    bool hasInstance(AppletInfo*);

    bool inMoveOperation() { return _movingAC; }

public slots:
    void startContainerMove(BaseContainer *a);
    void stopContainerMove(BaseContainer *a);

protected:
    void layoutChildren();

    BaseContainer* coversContainer(BaseContainer *a, bool strict);

    void updateContainerList();
    int relativeContainerPos(BaseContainer* a);
    int totalFreeSpace();
    int minimumUsedSpace();

    void mouseMoveEvent(QMouseEvent *);
    void mouseReleaseEvent(QMouseEvent *);

    void dragEnterEvent(QDragEnterEvent *ev);
    void dropEvent(QDropEvent *ev);

    void addContainer(BaseContainer* a);
    void removeContainer(BaseContainer *a);
    void removeAllContainers();

    void setUniqueId(BaseContainer* a);
    void moveToFirstFreePosition(BaseContainer* a);

    bool isStretch(BaseContainer* a);

    void saveContainerConfig(bool layoutOnly = false);
    void loadContainerConfig();
    void defaultContainerConfig();

    void moveContainerSwitch(BaseContainer* a, int distance);
    void moveContainerPush(BaseContainer* a, int distanceRequest);
    int moveContainerPushRec(QListIterator<BaseContainer> it, int distanceRequest);

protected slots:
    void embeddedWindowDestroyed();
    void slotSaveContainerConfig();
    void slotRemoveContainer(BaseContainer*);
    void slotLayoutChildren();
    void slotAddExternal(ExternalAppletContainer*);

private:
    QList<BaseContainer> _containers;

    bool _block_relayout;
    bool _movingAC;
    BaseContainer *_moveAC;
    QPoint _moveOffset;
};

#endif

