/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#ifndef __panel_h__
#define __panel_h__

#include <qwidget.h>
#include <dcopobject.h>

#include "global.h"

class QBoxLayout;
class QPopupMenu;
class QVBox;
class QTimer;
class ContainerArea;
class ContainerAreaBox;
class PanelOpMenu;
class HideButton;

class Panel : public QWidget, virtual public DCOPObject
{
  Q_OBJECT
  // This should be the macro K_DCOP, but kicker does not use dcopidl yet. To be fixed.
  virtual bool process(const QCString &fun, const QByteArray &data, QCString& replyType, QByteArray &replyData);
  QCStringList functions();

 public:
  Panel();
  ~Panel();

  Orientation orientation() const {  return isHorizontal()?Horizontal:Vertical; }
  Position position() const { return _pos; }
  void setPosition(Position p);
  Size size() const { return _size; }
  void setSize(Size s);

  int panelSize() const { return _panelsize; }

  ContainerArea *appletArea() { return(_appletArea); }

  bool eventFilter( QObject *, QEvent * );

  void writeConfig();
  void configure();
    
  QRect initialGeometry();

 signals:
  void orientationChanged(Orientation);
  void popupDirectionChanged(Direction);
  void configurationChanged();

 protected:
  bool isHorizontal() const { return _pos == Top || _pos == Bottom; }
  bool isVertical() const { return _pos == Left || _pos == Right; }
  void blockUserInput( bool block );
  void resetLayout();
  void closeEvent( QCloseEvent * );
  void updateWindowManager();
  void moveMe();
  void resetAutoHideTimer();
  void autoHide(bool hide);

  QPoint getPopupPosition(QPopupMenu *menu);

 protected slots:
  void hideLeft();
  void hideRight();
  void autoHideTimeout();
  void slotRestart();
  void workAreaChanged();

 private:

  void animatedHide(bool left);

  Size _size;
  Position _pos;
  bool _showHBs;
  int _HBwidth;
  int _panelsize;
  bool _autoHide;
  bool _autoHidden;
  bool _userHidden;
  bool _hideAnim, _autoHideAnim;
  int _autoHideDelay;
  int _hideAnimSpeed, _autoHideAnimSpeed;

  bool _block_user_input;
  QPoint _last_lmb_press;

  ContainerAreaBox *_appletAreaBox;
  QBoxLayout *_layout;
  QTimer     *_autohideTimer;
  HideButton *_ltHB;
  HideButton *_rbHB;

  ContainerArea *_appletArea;
  PanelOpMenu *_opMnu;

    bool _faked_activation;
};

#endif // __panel_h__
