/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <unistd.h>
#include <iostream.h>

#include <qpixmap.h>
#include <qdragobject.h>
#include <qdir.h>

#include <kiconloader.h>
#include <kglobal.h>
#include <kconfig.h>
#include <kdesktopfile.h>
#include <kmimetype.h>
#include <klocale.h>
#include <kglobalsettings.h>
#include <kapp.h>
#include <kio/global.h>
#include <kprocess.h>
#include <krun.h>

#include "browser_mnu.h"
#include "browser_mnu.moc"

PanelBrowserMenu::PanelBrowserMenu(QString startDir, bool expandFSTypes,
                                   bool ignoreEmptyDirs, QWidget *parent,
                                   const char *name, int filter, int sorting)
    : PanelMenu(startDir, parent, name), expandFS(expandFSTypes), ignoreEmpty(ignoreEmptyDirs),
      maxedOut(false)
{
    KConfig *config = KGlobal::config();
    config->setGroup("menus");
    max = config->readNumEntry("MaxEntries", 100);

    // gcc didn't like me using QDir:: for the type in the declaration
    filterSpec = (QDir::FilterSpec)filter;
    sortSpec = (QDir::SortSpec)sorting;
}

PanelBrowserMenu *PanelBrowserMenu::createSubMenu(QString startDir, bool expandFSTypes,
						  bool ignoreEmptyDirs, QWidget *parent,
						  const char *name, int filter, int sorting)
{
  return new PanelBrowserMenu(startDir, expandFSTypes, ignoreEmptyDirs,
			      parent, name, filter, sorting);
}

void PanelBrowserMenu::initialize()
{
    if (init) return;
    init = true;

    fileList.clear();

    insertItem(SmallIcon("konqueror"), i18n("Open File Manager"),
	       this, SLOT(slotOpenFileManager()));
    insertItem(SmallIcon("terminal"), i18n("Open Terminal"),
	       this, SLOT(slotOpenTerminal()));
    insertSeparator();

    QDir dir(startPath, QString::null, sortSpec, filterSpec);

    if (!dir.exists())
	return;

    const QFileInfoList *list = dir.entryInfoList();

    if (!list) {
	insertItem(i18n("Failed to read directory."));
	maxedOut = true;
	return;
    }

    if (list->count() > max) {
	maxedOut = true;
	insertItem(i18n("Too many files to load."));
	return;
    }

    QFileInfo *fi = 0;

    for (QFileInfoListIterator it(*list); it.current(); ++it)
	{
	    QPixmap smallIcon;
	    fi = it.current();

	    QString fileName = fi->fileName();
	    QString absFilePath = fi->absFilePath();

	    // directories
	    if (fi->isDir() && fileName != "." && fileName != "..")
		{
		    // handle empty dirs
		    bool empty = QDir(absFilePath, QString::null, QDir::Unsorted,QDir::Files).count()==0;
		
		    if (ignoreEmpty && empty)
			continue;

		    QString dirFile(absFilePath + "/.directory");
		    QString entryName;

		    // parse .directory
		    if (QFile::exists(dirFile)) {
			KDesktopFile f(dirFile);
			smallIcon = SmallIcon(f.readIcon());
			entryName = f.readName();
		    }

		    // create submenu
		    PanelBrowserMenu *subMenu = createSubMenu(absFilePath, expandFS, ignoreEmpty, this);
		
		    if (entryName.isNull()) entryName = fileName;
		    if(smallIcon.isNull())
			append(SmallIcon("folder"), entryName, subMenu);
		    else
			append(smallIcon, entryName, subMenu);
		}
	    // files
	    else if(fi->isFile() && fileName != ".directory" && fileName != ".order")
		{
                    KURL url;
                    url.setPath(absFilePath);
		    smallIcon = KMimeType::pixmapForURL(url, 0, 0, KIcon::SizeSmall);
		    // .desktop files
		    if(KDesktopFile::isDesktopFile(absFilePath))
			{
			    KDesktopFile dFile(absFilePath);
                            QString name = dFile.readName();
			    append(smallIcon, name.isEmpty() ? KIO::decodeFileName(fileName) : name, fileName);
			}
		    // normal files
		    else
			{
			    if(!smallIcon.isNull())
				append(smallIcon, KIO::decodeFileName(fileName), fileName);
			    else
				append(SmallIcon("unknown"), KIO::decodeFileName(fileName), fileName);
			}
		}
	}
}

void PanelBrowserMenu::append(const QPixmap &pixmap, const QString &title,
                              const QString &fileName)
{
    fileList.append(fileName);

    // Avoid &'s being converted to accelerators
    QString newTitle = title;
    newTitle.replace(QRegExp("&"), "&&");

    insertItem(pixmap, newTitle, fileList.count()-1);
}

void PanelBrowserMenu::append(const QPixmap &pixmap, const QString &title,
                              PanelBrowserMenu *subMenu)
{
    fileList.append(""); // keep in sync

    // Avoid &'s being converted to accelerators
    QString newTitle = title;
    newTitle.replace(QRegExp("&"), "&&");

    insertItem(pixmap, newTitle, subMenu, fileList.count()-1);
}

void PanelBrowserMenu::mousePressEvent(QMouseEvent *me)
{
    QPopupMenu::mousePressEvent(me);
    m_pressedPos = me->pos();
}

void PanelBrowserMenu::mouseMoveEvent(QMouseEvent *me)
{
    QPopupMenu::mouseMoveEvent(me);

    if (!(me->state() & LeftButton))
      return;

    int id = idAt(m_pressedPos);

    // the >=0 thing is a neat hack to avoid checking manual items
    if (id >= 0 && !maxedOut && !fileList[id].isEmpty()) {
      QUriDrag *d = new QUriDrag(this);
      d->setPixmap(iconSet(id)->pixmap());
      QStringList l;
      d->setFilenames(QStringList(startPath + "/" + fileList[id]));
      d->drag();
      close();
    }
}

void PanelBrowserMenu::slotExec(int id)
{
    kapp->propagateSessionManager();

    // the >=0 thing is a neat hack to avoid checking manual items
    if(id >= 0 && !maxedOut && !fileList[id].isEmpty()) {
        KURL url;
        url.setPath(startPath + "/" + fileList[id]);
	new KRun(url, 0, true);
    }
}

void PanelBrowserMenu::slotOpenTerminal()
{
    KConfig *config = KGlobal::config();
    config->setGroup("misc");
    QString term = config->readEntry("Terminal", "konsole");

    chdir(path().local8Bit());

    KProcess proc;
    proc.setExecutable(term);
    proc.start(KProcess::DontCare);
}

void PanelBrowserMenu::slotOpenFileManager()
{
    KProcess proc;
    proc << "konqueror" << "file:/" << path();
    proc.start(KProcess::DontCare);
}
